/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DatasetUtils;

public class DatasetDescription {
    private List<String> defaultGraphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();

    public static DatasetDescription create(List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return new DatasetDescription(defaultGraphURIs, namedGraphURIs);
    }

    public static DatasetDescription create(Query query) {
        return DatasetDescription.create(query, null);
    }

    public static DatasetDescription create(Context context) {
        return DatasetDescription.create(null, context);
    }

    public static DatasetDescription create(Query query, Context context) {
        if (context != null && context.isDefined(ARQConstants.sysDatasetDescription)) {
            try {
                return (DatasetDescription)context.get(ARQConstants.sysDatasetDescription);
            }
            catch (ClassCastException ex) {
                throw new ARQException("Unexpected type (expected DatasetDescription): " + ex.getMessage());
            }
        }
        if (query != null && query.hasDatasetDescription()) {
            return query.getDatasetDescription();
        }
        return null;
    }

    public DatasetDescription() {
    }

    public DatasetDescription(List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        this();
        this.addAllDefaultGraphURIs(defaultGraphURIs);
        this.addAllNamedGraphURIs(namedGraphURIs);
    }

    public boolean isEmpty() {
        return this.defaultGraphURIs.isEmpty() && this.namedGraphURIs.isEmpty();
    }

    public void addDefaultGraphURI(String uri) {
        this.defaultGraphURIs.add(uri);
    }

    public void addAllDefaultGraphURIs(Collection<String> uris) {
        this.defaultGraphURIs.addAll(uris);
    }

    public void addNamedGraphURI(String uri) {
        this.namedGraphURIs.add(uri);
    }

    public void addAllNamedGraphURIs(Collection<String> uris) {
        this.namedGraphURIs.addAll(uris);
    }

    public List<String> getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public Iterator<String> eachDefaultGraphURI() {
        return this.defaultGraphURIs.iterator();
    }

    public Iterator<String> eachNamedGraphURI() {
        return this.namedGraphURIs.iterator();
    }

    public Dataset createDataset() {
        return DatasetUtils.createDataset(this);
    }

    public DatasetGraph createDatasetGraph() {
        return DatasetUtils.createDatasetGraph(this);
    }

    public String toString() {
        return "DatasetDescription : " + this.defaultGraphURIs + " : " + this.namedGraphURIs;
    }
}

