/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sparql;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.sparql.SparqlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaInterpreter
implements SparqlEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenaInterpreter.class);
    private String serviceEndpoint;
    private boolean replaceURIs;
    private boolean removeDatatypes;
    private QueryExecution queryExecution;

    public JenaInterpreter(String serviceEndpoint, boolean replaceURIs, boolean removeDatatypes) {
        this.serviceEndpoint = serviceEndpoint;
        this.replaceURIs = replaceURIs;
        this.removeDatatypes = removeDatatypes;
    }

    @Override
    public InterpreterResult query(String query) {
        LOGGER.info("SPARQL: Run Query '" + query + "' against " + this.serviceEndpoint);
        try {
            this.queryExecution = QueryExecutionFactory.sparqlService(this.serviceEndpoint, query);
            PrefixMapping prefixMapping = this.queryExecution.getQuery().getPrefixMapping();
            ResultSet results = this.queryExecution.execSelect();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ResultSetFormatter.outputAsTSV((OutputStream)outputStream, results);
            String tsv = new String(outputStream.toByteArray());
            if (this.replaceURIs) {
                LOGGER.info("SPARQL: Replacing URIs");
                tsv = this.replaceURIs(tsv, prefixMapping);
            }
            if (this.removeDatatypes) {
                LOGGER.info("SPARQL: Removing datatypes");
                tsv = this.removeDatatypes(tsv);
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TABLE, tsv);
        }
        catch (QueryParseException e2) {
            LOGGER.error(e2.toString());
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Error: " + e2.getMessage());
        }
        catch (QueryExceptionHTTP e3) {
            LOGGER.error(e3.toString());
            int responseCode = e3.getResponseCode();
            if (responseCode == 401) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, "Unauthorized.");
            }
            if (responseCode == 404) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, "Endpoint not found, please check endpoint in the configuration.");
            }
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Error: " + e3.getMessage());
        }
        catch (ARQException e4) {
            return new InterpreterResult(InterpreterResult.Code.INCOMPLETE, "Query cancelled.");
        }
    }

    @Override
    public void cancel() {
        if (this.queryExecution != null) {
            this.queryExecution.abort();
        }
    }

    @Override
    public void close() {
        if (this.queryExecution != null) {
            this.queryExecution.close();
        }
    }

    private String replaceURIs(String tsv, PrefixMapping prefixMapping) {
        Map<String, String> pmap = prefixMapping.getNsPrefixMap();
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            tsv = tsv.replaceAll(entry.getValue(), entry.getKey() + ":");
        }
        return tsv;
    }

    private String removeDatatypes(String tsv) {
        return tsv.replaceAll("\"(.+?)\"\\^\\^\\<.+?\\>", "$1");
    }
}

