/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.MemberGroupService;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.protocols.backup.protocol.PrimitiveDescriptor;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.roles.BackupRole;
import io.atomix.protocols.backup.roles.NoneRole;
import io.atomix.protocols.backup.roles.PrimaryBackupRole;
import io.atomix.protocols.backup.roles.PrimaryRole;
import io.atomix.utils.concurrent.ComposableFuture;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.LogicalClock;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.WallClock;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class PrimaryBackupServiceContext
implements ServiceContext {
    private final Logger log;
    private final MemberId localMemberId;
    private final String serverName;
    private final PrimitiveId primitiveId;
    private final PrimitiveType primitiveType;
    private final ServiceConfig serviceConfig;
    private final PrimitiveDescriptor descriptor;
    private final PrimitiveService service;
    private final Map<Long, PrimaryBackupSession> sessions = Maps.newConcurrentMap();
    private final ThreadContext threadContext;
    private final ClusterMembershipService clusterMembershipService;
    private final MemberGroupService memberGroupService;
    private final PrimaryBackupServerProtocol protocol;
    private final PrimaryElection primaryElection;
    private MemberId primary;
    private List<MemberId> backups;
    private long currentTerm;
    private long currentIndex;
    private Session currentSession;
    private long currentTimestamp;
    private long operationIndex;
    private long commitIndex;
    private OperationType currentOperation = OperationType.COMMAND;
    private final LogicalClock logicalClock = new LogicalClock(){

        public LogicalTimestamp getTime() {
            return new LogicalTimestamp(PrimaryBackupServiceContext.this.operationIndex);
        }
    };
    private final WallClock wallClock = new WallClock(){

        public WallClockTimestamp getTime() {
            return WallClockTimestamp.from((long)PrimaryBackupServiceContext.this.currentTimestamp);
        }
    };
    private PrimaryBackupRole role;
    private final ClusterMembershipEventListener membershipEventListener = this::handleClusterEvent;
    private final PrimaryElectionEventListener primaryElectionListener = event -> this.changeRole(event.term());

    public PrimaryBackupServiceContext(String serverName, PrimitiveId primitiveId, PrimitiveType primitiveType, PrimitiveDescriptor descriptor, ThreadContext threadContext, ClusterMembershipService clusterMembershipService, MemberGroupService memberGroupService, PrimaryBackupServerProtocol protocol, PrimaryElection primaryElection) {
        this.localMemberId = clusterMembershipService.getLocalMember().id();
        this.serverName = (String)Preconditions.checkNotNull((Object)serverName);
        this.primitiveId = (PrimitiveId)Preconditions.checkNotNull((Object)primitiveId);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.serviceConfig = (ServiceConfig)Serializer.using((Namespace)primitiveType.namespace()).decode(descriptor.config());
        this.descriptor = (PrimitiveDescriptor)Preconditions.checkNotNull((Object)descriptor);
        this.service = primitiveType.newService(this.serviceConfig);
        this.threadContext = (ThreadContext)Preconditions.checkNotNull((Object)threadContext);
        this.clusterMembershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)clusterMembershipService);
        this.memberGroupService = (MemberGroupService)Preconditions.checkNotNull((Object)memberGroupService);
        this.protocol = (PrimaryBackupServerProtocol)Preconditions.checkNotNull((Object)protocol);
        this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)serverName).add("type", (Object)descriptor.type()).add("name", (Object)descriptor.name()).build());
        clusterMembershipService.addListener((EventListener)this.membershipEventListener);
        primaryElection.addListener((EventListener)this.primaryElectionListener);
    }

    public CompletableFuture<Void> open() {
        return ((CompletableFuture)this.primaryElection.getTerm().thenAccept(this::changeRole)).thenRun(() -> this.service.init((ServiceContext)this));
    }

    public PrimaryBackupServer.Role getRole() {
        return this.role.role();
    }

    public PrimitiveId serviceId() {
        return this.primitiveId;
    }

    public PrimitiveDescriptor descriptor() {
        return this.descriptor;
    }

    public MemberId memberId() {
        return this.localMemberId;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serviceName() {
        return this.descriptor.name();
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public <C extends ServiceConfig> C serviceConfig() {
        return (C)this.serviceConfig;
    }

    public long currentIndex() {
        return this.currentIndex;
    }

    public Session currentSession() {
        return this.currentSession;
    }

    public long currentTimestamp() {
        return this.currentTimestamp;
    }

    public long setTimestamp(long timestamp) {
        this.currentTimestamp = timestamp;
        this.service.tick(WallClockTimestamp.from((long)timestamp));
        return this.currentTimestamp;
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public void resetTerm(long term, MemberId primary) {
        this.currentTerm = term;
        this.primary = primary;
    }

    public long nextIndex() {
        this.currentOperation = OperationType.COMMAND;
        return ++this.operationIndex;
    }

    public boolean nextIndex(long index) {
        if (this.operationIndex + 1L == index) {
            this.currentOperation = OperationType.COMMAND;
            ++this.operationIndex;
            return true;
        }
        return false;
    }

    public void resetIndex(long index, long timestamp) {
        this.currentOperation = OperationType.COMMAND;
        this.operationIndex = index;
        this.currentIndex = index;
        this.currentTimestamp = timestamp;
        this.setCommitIndex(index);
        this.service.tick(new WallClockTimestamp(this.currentTimestamp));
    }

    public long setIndex(long index) {
        this.currentOperation = OperationType.COMMAND;
        this.currentIndex = index;
        return this.currentIndex;
    }

    public long getIndex() {
        this.currentOperation = OperationType.QUERY;
        return this.currentIndex;
    }

    public Session setSession(Session session) {
        this.currentSession = session;
        return session;
    }

    public long setCommitIndex(long commitIndex) {
        this.commitIndex = Math.max(this.commitIndex, commitIndex);
        return this.commitIndex;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public OperationType currentOperation() {
        return this.currentOperation;
    }

    public LogicalClock logicalClock() {
        return this.logicalClock;
    }

    public WallClock wallClock() {
        return this.wallClock;
    }

    public MemberId primary() {
        return this.primary;
    }

    public List<MemberId> backups() {
        return this.backups;
    }

    public ThreadContext threadContext() {
        return this.threadContext;
    }

    public PrimaryBackupServerProtocol protocol() {
        return this.protocol;
    }

    public PrimitiveService service() {
        return this.service;
    }

    public CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.execute(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.backup(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.role.restore(request).whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<CloseResponse> close(CloseRequest request) {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> {
            PrimaryBackupSession session = this.sessions.get(request.session());
            if (session != null) {
                this.role.close(session).whenComplete((result, error) -> {
                    if (error == null) {
                        future.complete((Object)CloseResponse.ok());
                    } else {
                        future.complete((Object)CloseResponse.error());
                    }
                });
            } else {
                future.complete((Object)CloseResponse.error());
            }
        });
        return future;
    }

    public Collection<PrimaryBackupSession> getSessions() {
        return ImmutableList.copyOf(this.sessions.values());
    }

    public PrimaryBackupSession getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public PrimaryBackupSession createSession(long sessionId, MemberId memberId) {
        PrimaryBackupSession session = new PrimaryBackupSession(SessionId.from((long)sessionId), memberId, this.service.serializer(), this);
        if (this.sessions.putIfAbsent(sessionId, session) == null) {
            this.service.register((Session)session);
        }
        return session;
    }

    public PrimaryBackupSession getOrCreateSession(long sessionId, MemberId memberId) {
        PrimaryBackupSession session = this.sessions.get(sessionId);
        if (session == null) {
            session = this.createSession(sessionId, memberId);
        }
        return session;
    }

    public void expireSession(long sessionId) {
        PrimaryBackupSession session = this.sessions.remove(sessionId);
        if (session != null) {
            this.log.debug("Expiring session {}", (Object)session.sessionId());
            session.expire();
            this.service.expire(session.sessionId());
        }
    }

    public void closeSession(long sessionId) {
        PrimaryBackupSession session = this.sessions.remove(sessionId);
        if (session != null) {
            this.log.debug("Closing session {}", (Object)session.sessionId());
            session.close();
            this.service.close(session.sessionId());
        }
    }

    private void handleClusterEvent(ClusterMembershipEvent event) {
        this.threadContext.execute(() -> {
            if (event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED) {
                for (Session session : this.sessions.values()) {
                    if (!session.memberId().equals((Object)((Member)event.subject()).id())) continue;
                    this.role.expire((PrimaryBackupSession)session);
                }
            }
        });
    }

    private void changeRole(PrimaryTerm term) {
        this.threadContext.execute(() -> {
            if (term.term() > this.currentTerm) {
                this.log.debug("Term changed: {}", (Object)term);
                this.currentTerm = term.term();
                this.primary = term.primary() != null ? term.primary().memberId() : null;
                this.backups = term.backups(this.descriptor.backups()).stream().map(GroupMember::memberId).collect(Collectors.toList());
                if (Objects.equals(this.primary, this.clusterMembershipService.getLocalMember().id())) {
                    if (this.role == null) {
                        this.role = new PrimaryRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.PRIMARY);
                    } else if (this.role.role() != PrimaryBackupServer.Role.PRIMARY) {
                        this.role.close();
                        this.role = new PrimaryRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.PRIMARY);
                    }
                } else if (this.backups.contains(this.clusterMembershipService.getLocalMember().id())) {
                    if (this.role == null) {
                        this.role = new BackupRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.BACKUP);
                    } else if (this.role.role() != PrimaryBackupServer.Role.BACKUP) {
                        this.role.close();
                        this.role = new BackupRole(this);
                        this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.BACKUP);
                    }
                } else if (this.role == null) {
                    this.role = new NoneRole(this);
                    this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.NONE);
                } else if (this.role.role() != PrimaryBackupServer.Role.NONE) {
                    this.role.close();
                    this.role = new NoneRole(this);
                    this.log.debug("{} transitioning to {}", (Object)this.clusterMembershipService.getLocalMember().id(), (Object)PrimaryBackupServer.Role.NONE);
                }
            }
        });
    }

    public CompletableFuture<Void> close() {
        CompletableFuture future = new CompletableFuture();
        this.threadContext.execute(() -> {
            try {
                this.clusterMembershipService.removeListener((EventListener)this.membershipEventListener);
                this.primaryElection.removeListener((EventListener)this.primaryElectionListener);
                this.role.close();
            }
            finally {
                future.complete(null);
            }
        });
        return future.thenRunAsync(() -> this.threadContext.close());
    }
}

