/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.raft.MultiRaftProtocol;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import java.time.Duration;

public class MultiRaftProtocolConfig
extends PrimitiveProtocolConfig<MultiRaftProtocolConfig> {
    private String group;
    private Partitioner<String> partitioner = Partitioner.MURMUR3;
    private Duration minTimeout = Duration.ofMillis(250L);
    private Duration maxTimeout = Duration.ofSeconds(30L);
    private ReadConsistency readConsistency = ReadConsistency.SEQUENTIAL;
    private CommunicationStrategy communicationStrategy = CommunicationStrategy.LEADER;
    private Recovery recoveryStrategy = Recovery.RECOVER;
    private int maxRetries = 0;
    private Duration retryDelay = Duration.ofMillis(100L);

    public PrimitiveProtocol.Type getType() {
        return MultiRaftProtocol.TYPE;
    }

    public String getGroup() {
        return this.group;
    }

    public MultiRaftProtocolConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    public Partitioner<String> getPartitioner() {
        return this.partitioner;
    }

    public MultiRaftProtocolConfig setPartitioner(Partitioner<String> partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public Duration getMinTimeout() {
        return this.minTimeout;
    }

    public MultiRaftProtocolConfig setMinTimeout(Duration minTimeout) {
        this.minTimeout = minTimeout;
        return this;
    }

    public Duration getMaxTimeout() {
        return this.maxTimeout;
    }

    public MultiRaftProtocolConfig setMaxTimeout(Duration maxTimeout) {
        this.maxTimeout = maxTimeout;
        return this;
    }

    public ReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public MultiRaftProtocolConfig setReadConsistency(ReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
        return this;
    }

    public CommunicationStrategy getCommunicationStrategy() {
        return this.communicationStrategy;
    }

    public MultiRaftProtocolConfig setCommunicationStrategy(CommunicationStrategy communicationStrategy) {
        this.communicationStrategy = communicationStrategy;
        return this;
    }

    public Recovery getRecoveryStrategy() {
        return this.recoveryStrategy;
    }

    public MultiRaftProtocolConfig setRecoveryStrategy(Recovery recoveryStrategy) {
        this.recoveryStrategy = recoveryStrategy;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public MultiRaftProtocolConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public MultiRaftProtocolConfig setRetryDelayMillis(long retryDelayMillis) {
        return this.setRetryDelay(Duration.ofMillis(retryDelayMillis));
    }

    public MultiRaftProtocolConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }
}

