/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.service.impl.DefaultBackupInput;
import io.atomix.primitive.service.impl.DefaultBackupOutput;
import io.atomix.primitive.service.impl.DefaultCommit;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionRegistry;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.buffer.BufferInput;
import io.atomix.storage.buffer.BufferOutput;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.LogicalClock;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.WallClock;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class RaftServiceContext
implements ServiceContext {
    private final Logger log;
    private final PrimitiveId primitiveId;
    private final String serviceName;
    private final PrimitiveType primitiveType;
    private final ServiceConfig config;
    private final PrimitiveService service;
    private final RaftContext raft;
    private final RaftSessionRegistry sessions;
    private final ThreadContextFactory threadContextFactory;
    private long currentIndex;
    private Session currentSession;
    private long currentTimestamp;
    private OperationType currentOperation;
    private final LogicalClock logicalClock = new LogicalClock(){

        public LogicalTimestamp getTime() {
            return new LogicalTimestamp(RaftServiceContext.this.currentIndex);
        }
    };
    private final WallClock wallClock = new WallClock(){

        public WallClockTimestamp getTime() {
            return new WallClockTimestamp(RaftServiceContext.this.currentTimestamp);
        }
    };

    public RaftServiceContext(PrimitiveId primitiveId, String serviceName, PrimitiveType primitiveType, ServiceConfig config, PrimitiveService service, RaftContext raft, ThreadContextFactory threadContextFactory) {
        this.primitiveId = (PrimitiveId)Preconditions.checkNotNull((Object)primitiveId);
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.config = (ServiceConfig)Preconditions.checkNotNull((Object)config);
        this.service = (PrimitiveService)Preconditions.checkNotNull((Object)service);
        this.raft = (RaftContext)Preconditions.checkNotNull((Object)raft);
        this.sessions = raft.getSessions();
        this.threadContextFactory = threadContextFactory;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)primitiveId).add("type", (Object)primitiveType).add("name", (Object)serviceName).build());
        service.init((ServiceContext)this);
    }

    public PrimitiveId serviceId() {
        return this.primitiveId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public <C extends ServiceConfig> C serviceConfig() {
        return (C)this.config;
    }

    public Serializer serializer() {
        return this.service.serializer();
    }

    public long currentIndex() {
        return this.currentIndex;
    }

    public Session currentSession() {
        return this.currentSession;
    }

    public OperationType currentOperation() {
        return this.currentOperation;
    }

    public LogicalClock logicalClock() {
        return this.logicalClock;
    }

    public WallClock wallClock() {
        return this.wallClock;
    }

    private void setOperation(OperationType operation) {
        this.currentOperation = operation;
    }

    private void tick(long index, long timestamp) {
        this.currentIndex = index;
        this.currentTimestamp = Math.max(this.currentTimestamp, timestamp);
        this.setOperation(OperationType.COMMAND);
        this.service.tick(WallClockTimestamp.from((long)timestamp));
    }

    private void expireSessions(long timestamp) {
        for (RaftSession session : this.sessions.getSessions(this.primitiveId)) {
            if (!session.isTimedOut(timestamp)) continue;
            this.log.debug("Session expired in {} milliseconds: {}", (Object)(timestamp - session.getLastUpdated()), (Object)session);
            if ((session = this.sessions.removeSession(session.sessionId())) == null) continue;
            session.expire();
            this.service.expire(session.sessionId());
        }
    }

    public void installSnapshot(SnapshotReader reader) {
        PrimitiveType primitiveType;
        this.log.debug("Installing snapshot {}", (Object)reader.snapshot().index());
        reader.skip(8);
        try {
            primitiveType = this.raft.getPrimitiveTypes().getPrimitiveType(reader.readString());
        }
        catch (ConfigurationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return;
        }
        String serviceName = reader.readString();
        int sessionCount = reader.readInt();
        for (int i = 0; i < sessionCount; ++i) {
            SessionId sessionId = SessionId.from((long)reader.readLong());
            MemberId node = MemberId.from((String)reader.readString());
            ReadConsistency readConsistency = ReadConsistency.valueOf(reader.readString());
            long minTimeout = reader.readLong();
            long maxTimeout = reader.readLong();
            long sessionTimestamp = reader.readLong();
            RaftSession session = this.raft.getSessions().addSession(new RaftSession(sessionId, node, serviceName, primitiveType, readConsistency, minTimeout, maxTimeout, sessionTimestamp, this.service.serializer(), this, this.raft, this.threadContextFactory));
            session.setRequestSequence(reader.readLong());
            session.setCommandSequence(reader.readLong());
            session.setEventIndex(reader.readLong());
            session.setLastCompleted(reader.readLong());
            session.setLastApplied(reader.snapshot().index());
            session.setLastUpdated(sessionTimestamp);
            this.service.register((Session)this.sessions.addSession(session));
        }
        this.currentIndex = reader.snapshot().index();
        this.currentTimestamp = reader.snapshot().timestamp().unixTimestamp();
        this.service.restore((BackupInput)new DefaultBackupInput((BufferInput)reader, this.service.serializer()));
    }

    public void takeSnapshot(SnapshotWriter writer) {
        this.log.debug("Taking snapshot {}", (Object)writer.snapshot().index());
        writer.writeLong((Long)this.primitiveId.id());
        writer.writeString(this.primitiveType.name());
        writer.writeString(this.serviceName);
        writer.writeInt(this.sessions.getSessions().size());
        for (RaftSession session : this.sessions.getSessions()) {
            writer.writeLong((Long)session.sessionId().id());
            writer.writeString((String)((Object)session.memberId().id()));
            writer.writeString(session.readConsistency().name());
            writer.writeLong(session.minTimeout());
            writer.writeLong(session.maxTimeout());
            writer.writeLong(session.getLastUpdated());
            writer.writeLong(session.getRequestSequence());
            writer.writeLong(session.getCommandSequence());
            writer.writeLong(session.getEventIndex());
            writer.writeLong(session.getLastCompleted());
        }
        this.service.backup((BackupOutput)new DefaultBackupOutput((BufferOutput)writer, this.service.serializer()));
    }

    public long openSession(long index, long timestamp, RaftSession session) {
        this.log.debug("Opening session {}", (Object)session.sessionId());
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        session.open();
        this.service.register((Session)this.sessions.addSession(session));
        this.commit();
        return (Long)session.sessionId().id();
    }

    public boolean keepAlive(long index, long timestamp, RaftSession session, long commandSequence, long eventIndex) {
        this.tick(index, timestamp);
        if (session.getState() != Session.State.CLOSED) {
            session.setLastUpdated(timestamp);
            session.clearResults(commandSequence);
            session.resendEvents(eventIndex);
            session.resetRequestSequence(commandSequence);
            session.setCommandSequence(commandSequence);
            return true;
        }
        return false;
    }

    public void completeKeepAlive(long index, long timestamp) {
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        this.commit();
    }

    public void keepAliveSessions(long index, long timestamp) {
        this.log.debug("Resetting session timeouts");
        this.currentIndex = index;
        this.currentTimestamp = Math.max(this.currentTimestamp, timestamp);
        for (RaftSession session : this.sessions.getSessions(this.primitiveId)) {
            session.setLastUpdated(timestamp);
        }
    }

    public void closeSession(long index, long timestamp, RaftSession session, boolean expired) {
        this.log.debug("Closing session {}", (Object)session.sessionId());
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        if (expired) {
            if ((session = this.sessions.removeSession(session.sessionId())) != null) {
                session.expire();
                this.service.expire(session.sessionId());
            }
        } else if ((session = this.sessions.removeSession(session.sessionId())) != null) {
            session.close();
            this.service.close(session.sessionId());
        }
        this.commit();
    }

    public OperationResult executeCommand(long index, long sequence, long timestamp, RaftSession session, PrimitiveOperation operation) {
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        if (!session.getState().active()) {
            this.log.warn("Session not open: {}", (Object)session);
            throw new RaftException.UnknownSession("Unknown session: " + session.sessionId(), new Object[0]);
        }
        if (sequence > 0L && sequence < session.nextCommandSequence()) {
            this.log.trace("Returning cached result for command with sequence number {} < {}", (Object)sequence, (Object)session.nextCommandSequence());
            return this.sequenceCommand(index, sequence, session);
        }
        return this.applyCommand(index, sequence, timestamp, operation, session);
    }

    private OperationResult sequenceCommand(long index, long sequence, RaftSession session) {
        OperationResult result = session.getResult(sequence);
        if (result == null) {
            this.log.debug("Missing command result at index {}", (Object)index);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult applyCommand(long index, long sequence, long timestamp, PrimitiveOperation operation, RaftSession session) {
        OperationResult result;
        DefaultCommit commit = new DefaultCommit(index, operation.id(), (Object)operation.value(), (Session)session, timestamp);
        long eventIndex = session.getEventIndex();
        try {
            this.currentSession = session;
            byte[] output = this.service.apply((Commit)commit);
            result = OperationResult.succeeded(index, eventIndex, output);
        }
        catch (Exception e) {
            result = OperationResult.failed(index, eventIndex, e);
        }
        finally {
            this.currentSession = null;
        }
        this.commit();
        session.registerResult(sequence, result);
        session.setCommandSequence(sequence);
        return result;
    }

    public CompletableFuture<OperationResult> executeQuery(long index, long sequence, long timestamp, RaftSession session, PrimitiveOperation operation) {
        CompletableFuture<OperationResult> future = new CompletableFuture<OperationResult>();
        this.executeQuery(index, sequence, timestamp, session, operation, future);
        return future;
    }

    private void executeQuery(long index, long sequence, long timestamp, RaftSession session, PrimitiveOperation operation, CompletableFuture<OperationResult> future) {
        if (!session.getState().active()) {
            this.log.warn("Inactive session: " + session.sessionId());
            future.completeExceptionally(new RaftException.UnknownSession("Unknown session: " + session.sessionId(), new Object[0]));
            return;
        }
        this.sequenceQuery(index, sequence, timestamp, session, operation, future);
    }

    private void sequenceQuery(long index, long sequence, long timestamp, RaftSession session, PrimitiveOperation operation, CompletableFuture<OperationResult> future) {
        long commandSequence = session.getCommandSequence();
        if (sequence > commandSequence) {
            this.log.trace("Registering query with sequence number " + sequence + " > " + commandSequence);
            session.registerSequenceQuery(sequence, () -> this.indexQuery(index, timestamp, session, operation, future));
        } else {
            this.indexQuery(index, timestamp, session, operation, future);
        }
    }

    private void indexQuery(long index, long timestamp, RaftSession session, PrimitiveOperation operation, CompletableFuture<OperationResult> future) {
        if (index > this.currentIndex) {
            this.log.trace("Registering query with index " + index + " > " + this.currentIndex);
            session.registerIndexQuery(index, () -> this.applyQuery(timestamp, session, operation, future));
        } else {
            this.applyQuery(timestamp, session, operation, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyQuery(long timestamp, RaftSession session, PrimitiveOperation operation, CompletableFuture<OperationResult> future) {
        OperationResult result;
        if (!session.getState().active()) {
            this.log.warn("Inactive session: " + session.sessionId());
            future.completeExceptionally(new RaftException.UnknownSession("Unknown session: " + session.sessionId(), new Object[0]));
            return;
        }
        this.setOperation(OperationType.QUERY);
        DefaultCommit commit = new DefaultCommit(this.currentIndex, operation.id(), (Object)operation.value(), (Session)session, timestamp);
        long eventIndex = session.getEventIndex();
        try {
            this.currentSession = session;
            result = OperationResult.succeeded(this.currentIndex, eventIndex, this.service.apply((Commit)commit));
        }
        catch (Exception e) {
            result = OperationResult.failed(this.currentIndex, eventIndex, e);
        }
        finally {
            this.currentSession = null;
        }
        future.complete(result);
    }

    private void commit() {
        long index = this.currentIndex;
        for (RaftSession session : this.sessions.getSessions(this.primitiveId)) {
            session.commit(index);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.raft.getName()).add("type", (Object)this.primitiveType).add("name", (Object)this.serviceName).add("id", (Object)this.primitiveId).toString();
    }
}

