/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.core.election.impl.BlockingLeaderElection;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TranscodingAsyncLeaderElection<V1, V2>
extends DelegatingAsyncPrimitive
implements AsyncLeaderElection<V1> {
    private final AsyncLeaderElection<V2> backingElection;
    private final Function<V1, V2> valueEncoder;
    private final Function<V2, V1> valueDecoder;
    private final Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncLeaderElection(AsyncLeaderElection<V2> backingElection, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingElection);
        this.backingElection = backingElection;
        this.valueEncoder = valueEncoder;
        this.valueDecoder = valueDecoder;
    }

    @Override
    public CompletableFuture<Leadership<V1>> run(V1 identifier) {
        return this.backingElection.run(this.valueEncoder.apply(identifier)).thenApply(l -> l.map(this.valueDecoder));
    }

    @Override
    public CompletableFuture<Void> withdraw(V1 identifier) {
        return this.backingElection.withdraw(this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Boolean> anoint(V1 identifier) {
        return this.backingElection.anoint(this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Void> evict(V1 identifier) {
        return this.backingElection.evict(this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Boolean> promote(V1 identifier) {
        return this.backingElection.promote(this.valueEncoder.apply(identifier));
    }

    @Override
    public CompletableFuture<Leadership<V1>> getLeadership() {
        return this.backingElection.getLeadership().thenApply(l -> l.map(this.valueDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.computeIfAbsent(listener, k -> new InternalLeadershipEventListener(listener));
            return this.backingElection.addListener(internalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(LeadershipEventListener<V1> listener) {
        Map<LeadershipEventListener<V1>, InternalLeadershipEventListener> map = this.listeners;
        synchronized (map) {
            InternalLeadershipEventListener internalListener = this.listeners.remove(listener);
            if (internalListener != null) {
                return this.backingElection.removeListener(internalListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public LeaderElection<V1> sync(Duration operationTimeout) {
        return new BlockingLeaderElection(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingElection", this.backingElection).toString();
    }

    private class InternalLeadershipEventListener
    implements LeadershipEventListener<V2> {
        private final LeadershipEventListener<V1> listener;

        InternalLeadershipEventListener(LeadershipEventListener<V1> listener) {
            this.listener = listener;
        }

        public void event(LeadershipEvent<V2> event) {
            this.listener.event((Event)new LeadershipEvent((LeadershipEvent.Type)event.type(), event.topic(), event.oldLeadership() != null ? event.oldLeadership().map(TranscodingAsyncLeaderElection.this.valueDecoder) : null, event.newLeadership() != null ? event.newLeadership().map(TranscodingAsyncLeaderElection.this.valueDecoder) : null));
        }
    }
}

