/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.list.AsyncDistributedList;
import io.atomix.core.list.DistributedList;
import io.atomix.core.list.DistributedListBuilder;
import io.atomix.core.list.DistributedListConfig;
import io.atomix.core.list.impl.CachingAsyncDistributedList;
import io.atomix.core.list.impl.DistributedListProxy;
import io.atomix.core.list.impl.DistributedListService;
import io.atomix.core.list.impl.TranscodingAsyncDistributedList;
import io.atomix.core.list.impl.UnmodifiableAsyncDistributedList;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedListBuilder<E>
extends DistributedListBuilder<E> {
    public DefaultDistributedListBuilder(String name, DistributedListConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedList<E>> buildAsync() {
        return ((CompletableFuture)this.newProxy(DistributedListService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedListProxy((ProxyClient<DistributedListService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawList -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive list = new TranscodingAsyncDistributedList<Object, String>((AsyncDistributedList<String>)rawList, element -> BaseEncoding.base16().encode(serializer.encode(element)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)));
            if (((DistributedListConfig)this.config).getCacheConfig().isEnabled()) {
                list = new CachingAsyncDistributedList(list, ((DistributedListConfig)this.config).getCacheConfig());
            }
            if (((DistributedListConfig)this.config).isReadOnly()) {
                list = new UnmodifiableAsyncDistributedList(list);
            }
            return list.sync();
        });
    }
}

