/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import io.atomix.core.lock.AsyncDistributedLock;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockResource.class);
    private final AsyncDistributedLock lock;

    public DistributedLockResource(AsyncDistributedLock lock) {
        this.lock = lock;
    }

    @POST
    @Path(value="/lock")
    @Produces(value={"application/json"})
    public void lock(@Suspended AsyncResponse response) {
        this.lock.lock().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/lock")
    public void unlock(@Suspended AsyncResponse response) {
        this.lock.unlock().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

