/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.primitive.AsyncPrimitive;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface AsyncDistributedMap<K, V>
extends AsyncPrimitive {
    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<Boolean> containsValue(V var1);

    public CompletableFuture<V> get(K var1);

    public CompletableFuture<V> put(K var1, V var2);

    public CompletableFuture<V> remove(K var1);

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> var1);

    public CompletableFuture<Void> clear();

    public AsyncDistributedSet<K> keySet();

    public AsyncDistributedCollection<V> values();

    public AsyncDistributedSet<Map.Entry<K, V>> entrySet();

    public CompletableFuture<V> getOrDefault(K var1, V var2);

    public CompletableFuture<V> putIfAbsent(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, V var2);

    public CompletableFuture<Boolean> replace(K var1, V var2, V var3);

    public CompletableFuture<V> replace(K var1, V var2);

    public CompletableFuture<V> computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public CompletableFuture<V> computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    public CompletableFuture<V> compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    default public CompletableFuture<Void> addListener(MapEventListener<K, V> listener) {
        return this.addListener(listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> var1, Executor var2);

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> var1);

    default public DistributedMap<K, V> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public DistributedMap<K, V> sync(Duration var1);
}

