/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface AsyncAtomicMultimap<K, V>
extends AsyncPrimitive {
    default public CompletableFuture<Void> delete() {
        return this.clear();
    }

    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<Boolean> containsValue(V var1);

    public CompletableFuture<Boolean> containsEntry(K var1, V var2);

    public CompletableFuture<Boolean> put(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, V var2);

    public CompletableFuture<Boolean> removeAll(K var1, Collection<? extends V> var2);

    public CompletableFuture<Versioned<Collection<V>>> removeAll(K var1);

    public CompletableFuture<Boolean> putAll(K var1, Collection<? extends V> var2);

    public CompletableFuture<Versioned<Collection<V>>> replaceValues(K var1, Collection<V> var2);

    public CompletableFuture<Void> clear();

    public CompletableFuture<Versioned<Collection<V>>> get(K var1);

    public AsyncDistributedSet<K> keySet();

    public AsyncDistributedMultiset<K> keys();

    public AsyncDistributedMultiset<V> values();

    public AsyncDistributedCollection<Map.Entry<K, V>> entries();

    public AsyncDistributedMap<K, Versioned<Collection<V>>> asMap();

    default public CompletableFuture<Void> addListener(AtomicMultimapEventListener<K, V> listener) {
        return this.addListener(listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(AtomicMultimapEventListener<K, V> var1, Executor var2);

    public CompletableFuture<Void> removeListener(AtomicMultimapEventListener<K, V> var1);

    default public AtomicMultimap<K, V> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public AtomicMultimap<K, V> sync(Duration var1);
}

