/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.impl.TranscodingAsyncDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AsyncDistributedMultimap;
import io.atomix.core.multimap.AtomicMultimapEvent;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multimap.DistributedMultimap;
import io.atomix.core.multimap.DistributedMultimapType;
import io.atomix.core.multimap.MultimapEvent;
import io.atomix.core.multimap.MultimapEventListener;
import io.atomix.core.multimap.impl.BlockingDistributedMultimap;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DelegatingAsyncDistributedMultimap<K, V>
extends DelegatingAsyncPrimitive
implements AsyncDistributedMultimap<K, V> {
    private final AsyncAtomicMultimap<K, V> atomicMultimap;
    private final Map<MultimapEventListener<K, V>, AtomicMultimapEventListener<K, V>> listenerMap = Maps.newConcurrentMap();

    public DelegatingAsyncDistributedMultimap(AsyncAtomicMultimap<K, V> atomicMultimap) {
        super(atomicMultimap);
        this.atomicMultimap = atomicMultimap;
    }

    public PrimitiveType type() {
        return DistributedMultimapType.instance();
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.atomicMultimap.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.atomicMultimap.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.atomicMultimap.containsKey(key);
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        return this.atomicMultimap.containsValue(value);
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.atomicMultimap.containsEntry(key, value);
    }

    @Override
    public CompletableFuture<Boolean> put(K key, V value) {
        return this.atomicMultimap.put(key, value);
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.atomicMultimap.remove(key, value);
    }

    @Override
    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return this.atomicMultimap.removeAll(key, values);
    }

    @Override
    public CompletableFuture<Collection<V>> removeAll(K key) {
        return this.atomicMultimap.removeAll(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return this.atomicMultimap.putAll(key, values);
    }

    @Override
    public CompletableFuture<Collection<V>> replaceValues(K key, Collection<V> values) {
        return this.atomicMultimap.replaceValues(key, values).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.atomicMultimap.clear();
    }

    @Override
    public CompletableFuture<Collection<V>> get(K key) {
        return this.atomicMultimap.get(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public AsyncDistributedSet<K> keySet() {
        return this.atomicMultimap.keySet();
    }

    @Override
    public AsyncDistributedMultiset<K> keys() {
        return this.atomicMultimap.keys();
    }

    @Override
    public AsyncDistributedMultiset<V> values() {
        return this.atomicMultimap.values();
    }

    @Override
    public AsyncDistributedCollection<Map.Entry<K, V>> entries() {
        return this.atomicMultimap.entries();
    }

    @Override
    public AsyncDistributedMap<K, Collection<V>> asMap() {
        return new TranscodingAsyncDistributedMap<Object, Collection, Object, Versioned>(this.atomicMultimap.asMap(), k -> k, k -> k, v -> new Versioned(v, 0L), Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Void> addListener(MultimapEventListener<K, V> listener, Executor executor) {
        InternalAtomicMultimapEventListener atomicListener = new InternalAtomicMultimapEventListener(listener);
        if (this.listenerMap.putIfAbsent(listener, atomicListener) == null) {
            return this.atomicMultimap.addListener(atomicListener, executor);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(MultimapEventListener<K, V> listener) {
        AtomicMultimapEventListener<K, V> atomicListener = this.listenerMap.remove(listener);
        if (atomicListener != null) {
            return this.atomicMultimap.removeListener(atomicListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DistributedMultimap<K, V> sync(Duration operationTimeout) {
        return new BlockingDistributedMultimap(this, operationTimeout.toMillis());
    }

    private class InternalAtomicMultimapEventListener
    implements AtomicMultimapEventListener<K, V> {
        private final MultimapEventListener<K, V> mapListener;

        InternalAtomicMultimapEventListener(MultimapEventListener<K, V> mapListener) {
            this.mapListener = mapListener;
        }

        public void event(AtomicMultimapEvent<K, V> event) {
            this.mapListener.event((Event)new MultimapEvent(MultimapEvent.Type.valueOf(((AtomicMultimapEvent.Type)event.type()).name()), event.key(), event.newValue(), event.oldValue()));
        }
    }
}

