/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.Multiset;
import io.atomix.core.cache.CacheConfig;
import io.atomix.core.collection.impl.CachingAsyncDistributedCollection;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class CachingAsyncDistributedMultiset<E>
extends CachingAsyncDistributedCollection<E>
implements AsyncDistributedMultiset<E> {
    private final AsyncDistributedMultiset<E> backingMultiset;

    public CachingAsyncDistributedMultiset(AsyncDistributedMultiset<E> backingCollection, CacheConfig config) {
        super(backingCollection, config);
        this.backingMultiset = backingCollection;
    }

    @Override
    public CompletableFuture<Integer> count(Object element) {
        return this.backingMultiset.count(element);
    }

    @Override
    public CompletableFuture<Integer> add(E element, int occurrences) {
        return this.backingMultiset.add(element, occurrences).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public CompletableFuture<Integer> remove(Object element, int occurrences) {
        return this.backingMultiset.remove(element, occurrences).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public CompletableFuture<Integer> setCount(E element, int count) {
        return this.backingMultiset.setCount(element, count).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public CompletableFuture<Boolean> setCount(E element, int oldCount, int newCount) {
        return this.backingMultiset.setCount(element, oldCount, newCount).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public AsyncDistributedSet<E> elementSet() {
        return this.backingMultiset.elementSet();
    }

    @Override
    public AsyncDistributedSet<Multiset.Entry<E>> entrySet() {
        return this.backingMultiset.entrySet();
    }

    @Override
    public DistributedMultiset<E> sync(Duration operationTimeout) {
        return new BlockingDistributedMultiset(this, operationTimeout.toMillis());
    }
}

