/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.primitive.resource.PrimitiveResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicValueResource
implements PrimitiveResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicValueResource.class);
    private final AsyncAtomicValue<String> value;

    public AtomicValueResource(AsyncAtomicValue<String> value) {
        this.value = value;
    }

    @GET
    @Path(value="/value")
    @Produces(value={"application/json"})
    public void get(@Suspended AsyncResponse response) {
        this.value.get().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/value")
    @Consumes(value={"text/plain"})
    public void set(String body, @Suspended AsyncResponse response) {
        this.value.set(body).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/cas")
    @Produces(value={"application/json"})
    public void compareAndSet(CompareAndSetRequest request, @Suspended AsyncResponse response) {
        this.value.compareAndSet(request.getExpect(), request.getUpdate()).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class CompareAndSetRequest {
        private String expect;
        private String update;

        CompareAndSetRequest() {
        }

        public String getExpect() {
            return this.expect;
        }

        public void setExpect(String expect) {
            this.expect = expect;
        }

        public String getUpdate() {
            return this.update;
        }

        public void setUpdate(String update) {
            this.update = update;
        }
    }
}

