/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValue;
import io.atomix.core.value.AtomicValueEventListener;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicValue<V>
extends Synchronous<AsyncAtomicValue<V>>
implements AtomicValue<V> {
    private final AsyncAtomicValue<V> asyncValue;
    private final long operationTimeoutMillis;

    public BlockingAtomicValue(AsyncAtomicValue<V> asyncValue, long operationTimeoutMillis) {
        super(asyncValue);
        this.asyncValue = asyncValue;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.complete(this.asyncValue.compareAndSet(expect, update));
    }

    @Override
    public V get() {
        return this.complete(this.asyncValue.get());
    }

    @Override
    public V getAndSet(V value) {
        return this.complete(this.asyncValue.getAndSet(value));
    }

    @Override
    public void set(V value) {
        this.complete(this.asyncValue.set(value));
    }

    @Override
    public void addListener(AtomicValueEventListener<V> listener) {
        this.complete(this.asyncValue.addListener(listener));
    }

    @Override
    public void removeListener(AtomicValueEventListener<V> listener) {
        this.complete(this.asyncValue.removeListener(listener));
    }

    @Override
    public AsyncAtomicValue<V> async() {
        return this.asyncValue;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

