/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import io.atomix.core.value.AsyncDistributedValue;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.value.ValueEventListener;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingDistributedValue<V>
extends Synchronous<AsyncDistributedValue<V>>
implements DistributedValue<V> {
    private final AsyncDistributedValue<V> asyncValue;
    private final long operationTimeoutMillis;

    public BlockingDistributedValue(AsyncDistributedValue<V> asyncValue, long operationTimeoutMillis) {
        super(asyncValue);
        this.asyncValue = asyncValue;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public V get() {
        return this.complete(this.asyncValue.get());
    }

    @Override
    public V getAndSet(V value) {
        return this.complete(this.asyncValue.getAndSet(value));
    }

    @Override
    public void set(V value) {
        this.complete(this.asyncValue.set(value));
    }

    @Override
    public void addListener(ValueEventListener<V> listener) {
        this.complete(this.asyncValue.addListener(listener));
    }

    @Override
    public void removeListener(ValueEventListener<V> listener) {
        this.complete(this.asyncValue.removeListener(listener));
    }

    @Override
    public AsyncDistributedValue<V> async() {
        return this.asyncValue;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

