/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import com.google.common.collect.Maps;
import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AsyncDistributedValue;
import io.atomix.core.value.AtomicValueEvent;
import io.atomix.core.value.AtomicValueEventListener;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.value.ValueEvent;
import io.atomix.core.value.ValueEventListener;
import io.atomix.core.value.impl.BlockingDistributedValue;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DelegatingAsyncDistributedValue<V>
extends DelegatingAsyncPrimitive<AsyncAtomicValue<V>>
implements AsyncDistributedValue<V> {
    private final Map<ValueEventListener<V>, AtomicValueEventListener<V>> listenerMap = Maps.newConcurrentMap();

    public DelegatingAsyncDistributedValue(AsyncAtomicValue<V> primitive) {
        super(primitive);
    }

    @Override
    public CompletableFuture<V> get() {
        return ((AsyncAtomicValue)this.delegate()).get();
    }

    @Override
    public CompletableFuture<V> getAndSet(V value) {
        return ((AsyncAtomicValue)this.delegate()).getAndSet(value);
    }

    @Override
    public CompletableFuture<Void> set(V value) {
        return ((AsyncAtomicValue)this.delegate()).set(value);
    }

    @Override
    public CompletableFuture<Void> addListener(ValueEventListener<V> listener) {
        AtomicValueEventListener eventListener = event -> listener.event((Event)new ValueEvent(ValueEvent.Type.valueOf(((AtomicValueEvent.Type)event.type()).name()), event.newValue(), event.oldValue()));
        if (this.listenerMap.putIfAbsent(listener, eventListener) == null) {
            return ((AsyncAtomicValue)this.delegate()).addListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(ValueEventListener<V> listener) {
        AtomicValueEventListener<V> eventListener = this.listenerMap.remove(listener);
        if (eventListener != null) {
            return ((AsyncAtomicValue)this.delegate()).removeListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DistributedValue<V> sync(Duration operationTimeout) {
        return new BlockingDistributedValue(this, operationTimeout.toMillis());
    }
}

