/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import io.atomix.core.workqueue.Task;
import io.atomix.core.workqueue.WorkQueueStats;
import io.atomix.core.workqueue.WorkQueueType;
import io.atomix.core.workqueue.impl.WorkQueueClient;
import io.atomix.core.workqueue.impl.WorkQueueService;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DefaultWorkQueueService
extends AbstractPrimitiveService<WorkQueueClient>
implements WorkQueueService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(WorkQueueType.instance().namespace()).register(new Class[]{TaskAssignment.class}).register(new Class[]{new HashMap().keySet().getClass()}).register(new Class[]{ArrayDeque.class}).register(new Class[]{SessionId.class}).build());
    private final AtomicLong totalCompleted = new AtomicLong(0L);
    private Queue<Task<byte[]>> unassignedTasks = Queues.newArrayDeque();
    private Map<String, TaskAssignment> assignments = Maps.newHashMap();
    private Set<SessionId> registeredWorkers = Sets.newLinkedHashSet();

    public DefaultWorkQueueService() {
        super(WorkQueueType.instance(), WorkQueueClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput writer) {
        writer.writeObject(this.registeredWorkers);
        writer.writeObject(this.assignments);
        writer.writeObject(this.unassignedTasks);
        writer.writeLong(this.totalCompleted.get());
    }

    public void restore(BackupInput reader) {
        this.registeredWorkers = (Set)reader.readObject();
        this.assignments = (Map)reader.readObject();
        this.unassignedTasks = (Queue)reader.readObject();
        this.totalCompleted.set(reader.readLong());
    }

    @Override
    public WorkQueueStats stats() {
        return WorkQueueStats.builder().withTotalCompleted(this.totalCompleted.get()).withTotalPending(this.unassignedTasks.size()).withTotalInProgress(this.assignments.size()).build();
    }

    @Override
    public void clear() {
        this.unassignedTasks.clear();
        this.assignments.clear();
        this.registeredWorkers.clear();
        this.totalCompleted.set(0L);
    }

    @Override
    public void register() {
        this.registeredWorkers.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unregister() {
        this.registeredWorkers.remove(this.getCurrentSession().sessionId());
    }

    @Override
    public void add(Collection<byte[]> items) {
        AtomicInteger itemIndex = new AtomicInteger(0);
        items.forEach(item -> {
            String taskId = String.format("%d:%d:%d", this.getCurrentSession().sessionId().id(), this.getCurrentIndex(), itemIndex.getAndIncrement());
            this.unassignedTasks.add(new Task<byte[]>(taskId, (byte[])item));
        });
        this.registeredWorkers.forEach(sessionId -> this.getSession((SessionId)sessionId).accept(client -> client.taskAvailable()));
    }

    @Override
    public Collection<Task<byte[]>> take(int maxTasks) {
        try {
            if (this.unassignedTasks.isEmpty()) {
                return ImmutableList.of();
            }
            long sessionId = (Long)this.getCurrentSession().sessionId().id();
            return IntStream.range(0, Math.min(maxTasks, this.unassignedTasks.size())).mapToObj(i -> {
                Task<byte[]> task = this.unassignedTasks.poll();
                String taskId = task.taskId();
                TaskAssignment assignment = new TaskAssignment(sessionId, task);
                this.assignments.put(taskId, assignment);
                return task;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            this.getLogger().warn("State machine update failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void complete(Collection<String> taskIds) {
        try {
            taskIds.forEach(taskId -> {
                TaskAssignment assignment = this.assignments.get(taskId);
                if (assignment != null && assignment.sessionId() == ((Long)this.getCurrentSession().sessionId().id()).longValue()) {
                    this.assignments.remove(taskId);
                    this.totalCompleted.incrementAndGet();
                }
            });
        }
        catch (Exception e) {
            this.getLogger().warn("State machine update failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void onExpire(Session session) {
        this.evictWorker(session.sessionId());
    }

    public void onClose(Session session) {
        this.evictWorker(session.sessionId());
    }

    private void evictWorker(SessionId sessionId) {
        this.registeredWorkers.remove(sessionId);
        Iterator<Map.Entry<String, TaskAssignment>> iter = this.assignments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, TaskAssignment> entry = iter.next();
            TaskAssignment assignment = entry.getValue();
            if (assignment.sessionId() != ((Long)sessionId.id()).longValue()) continue;
            this.unassignedTasks.add(assignment.task());
            iter.remove();
        }
    }

    private static class TaskAssignment {
        private final long sessionId;
        private final Task<byte[]> task;

        public TaskAssignment(long sessionId, Task<byte[]> task) {
            this.sessionId = sessionId;
            this.task = task;
        }

        public long sessionId() {
            return this.sessionId;
        }

        public Task<byte[]> task() {
            return this.task;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("sessionId", this.sessionId).add("task", this.task).toString();
        }
    }
}

