/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.graph.neo4j;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jConnectionManager {
    static final Logger LOGGER = LoggerFactory.getLogger(Neo4jConnectionManager.class);
    public static final String NEO4J_SERVER_URL = "neo4j.url";
    public static final String NEO4J_DATABASE = "neo4j.database";
    public static final String NEO4J_AUTH_TYPE = "neo4j.auth.type";
    public static final String NEO4J_AUTH_USER = "neo4j.auth.user";
    public static final String NEO4J_AUTH_PASSWORD = "neo4j.auth.password";
    public static final String NEO4J_MAX_CONCURRENCY = "neo4j.max.concurrency";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\{\\w+\\}");
    private static final String REPLACE_CURLY_BRACKETS = "\\{|\\}";
    private static final Pattern $_PATTERN = Pattern.compile("\\$\\w+\\}");
    private static final String REPLACE_$ = "\\$";
    private Driver driver = null;
    private final String neo4jUrl;
    private final Config config;
    private final AuthToken authToken;
    private final String database;

    public Neo4jConnectionManager(Properties properties) {
        this.neo4jUrl = properties.getProperty(NEO4J_SERVER_URL);
        this.config = Config.defaultConfig();
        this.database = properties.getProperty(NEO4J_DATABASE);
        this.authToken = this.initAuth(properties);
    }

    private AuthToken initAuth(Properties properties) {
        String authType = properties.getProperty(NEO4J_AUTH_TYPE);
        switch (Neo4jAuthType.valueOf(authType.toUpperCase())) {
            case BASIC: {
                String username = properties.getProperty(NEO4J_AUTH_USER);
                String password = properties.getProperty(NEO4J_AUTH_PASSWORD);
                return AuthTokens.basic(username, password);
            }
            case NONE: {
                LOGGER.debug("Creating NONE authentication");
                return AuthTokens.none();
            }
        }
        throw new RuntimeException("Neo4j authentication type not supported");
    }

    private Driver getDriver() {
        if (this.driver == null) {
            this.driver = GraphDatabase.driver(this.neo4jUrl, this.authToken, this.config);
        }
        return this.driver;
    }

    public void open() {
        this.getDriver();
    }

    public void close() {
        this.getDriver().close();
    }

    private Session getSession() {
        return this.getDriver().session(StringUtils.isNotEmpty(this.database) ? SessionConfig.forDatabase(this.database) : SessionConfig.defaultConfig());
    }

    public List<Record> execute(String cypherQuery, InterpreterContext interpreterContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (interpreterContext != null) {
            ResourcePool resourcePool = interpreterContext.getResourcePool();
            Set<String> keys = this.extractParams(cypherQuery, PROPERTY_PATTERN, REPLACE_CURLY_BRACKETS);
            keys.addAll(this.extractParams(cypherQuery, $_PATTERN, REPLACE_$));
            for (String key : keys) {
                Resource resource = resourcePool.get(key);
                if (resource == null) continue;
                params.put(key, resource.get());
            }
        }
        LOGGER.debug("Executing cypher query {} with params {}", (Object)cypherQuery, (Object)params);
        try (Session session = this.getSession();){
            Result result = params.isEmpty() ? session.run(cypherQuery) : session.run(cypherQuery, params);
            List<Record> list = result.list();
            return list;
        }
    }

    public List<Record> execute(String cypherQuery) {
        return this.execute(cypherQuery, null);
    }

    private Set<String> extractParams(String cypherQuery, Pattern pattern, String replaceChar) {
        Matcher matcher = pattern.matcher(cypherQuery);
        HashSet<String> keys = new HashSet<String>();
        while (matcher.find()) {
            keys.add(matcher.group().replaceAll(replaceChar, ""));
        }
        return keys;
    }

    public static enum Neo4jAuthType {
        NONE,
        BASIC;

    }
}

