/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;

public interface NotebookRepo {
    public void init(ZeppelinConfiguration var1) throws IOException;

    @ZeppelinApi
    public Map<String, NoteInfo> list(AuthenticationInfo var1) throws IOException;

    @ZeppelinApi
    public Note get(String var1, String var2, AuthenticationInfo var3) throws IOException;

    @ZeppelinApi
    public void save(Note var1, AuthenticationInfo var2) throws IOException;

    @ZeppelinApi
    public void move(String var1, String var2, String var3, AuthenticationInfo var4) throws IOException;

    public void move(String var1, String var2, AuthenticationInfo var3) throws IOException;

    @ZeppelinApi
    public void remove(String var1, String var2, AuthenticationInfo var3) throws IOException;

    @ZeppelinApi
    public void remove(String var1, AuthenticationInfo var2) throws IOException;

    @ZeppelinApi
    public void close();

    @ZeppelinApi
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo var1);

    @ZeppelinApi
    public void updateSettings(Map<String, String> var1, AuthenticationInfo var2);

    default public String buildNoteFileName(String noteId, String notePath) throws IOException {
        if (!notePath.startsWith("/")) {
            throw new IOException("Invalid notePath: " + notePath);
        }
        return (notePath + "_" + noteId + ".zpln").substring(1);
    }

    default public String buildNoteFileName(Note note) throws IOException {
        return this.buildNoteFileName(note.getId(), note.getPath());
    }

    default public String buildNoteTempFileName(Note note) {
        return (note.getPath() + "_" + note.getId() + ".tmp").substring(1);
    }

    default public String getNoteId(String noteFileName) throws IOException {
        int separatorIndex = noteFileName.lastIndexOf("_");
        if (separatorIndex == -1) {
            throw new IOException("Invalid note name, no '_' in note name: " + noteFileName);
        }
        try {
            int dotIndex = noteFileName.lastIndexOf(".");
            return noteFileName.substring(separatorIndex + 1, dotIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IOException("Invalid note name: " + noteFileName);
        }
    }

    default public String getNotePath(String rootNoteFolder, String noteFileName) throws IOException {
        int index = noteFileName.lastIndexOf("_");
        if (index == -1) {
            throw new IOException("Invalid note name, no '_' in note name: " + noteFileName);
        }
        try {
            return noteFileName.substring(rootNoteFolder.length(), index);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IOException("Invalid note name: " + noteFileName);
        }
    }
}

