/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import com.google.common.collect.ObjectArrays;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetIndexRequest
extends ClusterInfoRequest<GetIndexRequest> {
    private static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS, Feature.WARMERS};
    private Feature[] features = DEFAULT_FEATURES;
    private boolean humanReadable = false;

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new IllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... features) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(features);
        }
        return this.features(ObjectArrays.concat(this.featuresAsEnums(), features, Feature.class));
    }

    public Feature[] features() {
        return this.features;
    }

    @Deprecated
    public Feature[] featuresAsEnums() {
        return this.features();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public GetIndexRequest humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.features = new Feature[size];
        for (int i = 0; i < size; ++i) {
            this.features[i] = Feature.fromId(in.readByte());
        }
        this.humanReadable = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.features.length);
        for (Feature feature : this.features) {
            out.writeByte(feature.id);
        }
        out.writeBoolean(this.humanReadable);
    }

    public static final class Feature
    extends Enum<Feature> {
        public static final /* enum */ Feature ALIASES = new Feature(0, "_aliases", "_alias");
        public static final /* enum */ Feature MAPPINGS = new Feature(1, "_mappings", "_mapping");
        public static final /* enum */ Feature SETTINGS = new Feature(2, "_settings");
        public static final /* enum */ Feature WARMERS = new Feature(3, "_warmers", "_warmer");
        private static final Feature[] FEATURES;
        private final List<String> validNames;
        private final String preferredName;
        private final byte id;
        private static final /* synthetic */ Feature[] $VALUES;

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public static Feature valueOf(String name) {
            return Enum.valueOf(Feature.class, name);
        }

        private Feature(byte id, String ... validNames) {
            assert (validNames != null && validNames.length > 0);
            this.id = id;
            this.validNames = Arrays.asList(validNames);
            this.preferredName = validNames[0];
        }

        public byte id() {
            return this.id;
        }

        public String preferredName() {
            return this.preferredName;
        }

        public boolean validName(String name) {
            return this.validNames.contains(name);
        }

        public static Feature fromName(String name) {
            for (Feature feature : Feature.values()) {
                if (!feature.validName(name)) continue;
                return feature;
            }
            throw new IllegalArgumentException("No feature for name [" + name + "]");
        }

        public static Feature fromId(byte id) {
            if (id < 0 || id >= FEATURES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return FEATURES[id];
        }

        public static Feature[] convertToFeatures(String ... featureNames) {
            Feature[] features = new Feature[featureNames.length];
            for (int i = 0; i < featureNames.length; ++i) {
                features[i] = Feature.fromName(featureNames[i]);
            }
            return features;
        }

        static {
            $VALUES = new Feature[]{ALIASES, MAPPINGS, SETTINGS, WARMERS};
            FEATURES = new Feature[Feature.values().length];
            for (Feature feature : Feature.values()) {
                assert (feature.id() < FEATURES.length && feature.id() >= 0);
                Feature.FEATURES[feature.id] = feature;
            }
        }
    }
}

