/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.spi;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.ElementVisitor;

public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object source, Class<? extends Annotation> annotationType, Scope scope) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.annotationType = Preconditions.checkNotNull(annotationType, "annotationType");
        this.scope = Preconditions.checkNotNull(scope, "scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }
}

