/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final String INDEX_MAPPER_DYNAMIC_SETTING = "index.mapper.dynamic";
    public static final String INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = "index.mapping.nested_fields.limit";
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    private static ObjectHashSet<String> META_FIELDS = ObjectHashSet.from("_uid", "_id", "_type", "_all", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl");
    private static final Function<MappedFieldType, Analyzer> INDEX_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        @Override
        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.indexAnalyzer();
        }
    };
    private static final Function<MappedFieldType, Analyzer> SEARCH_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        @Override
        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.searchAnalyzer();
        }
    };
    private static final Function<MappedFieldType, Analyzer> SEARCH_QUOTE_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        @Override
        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.searchQuoteAnalyzer();
        }
    };
    private final Settings indexSettings;
    private final IndexSettingsService indexSettingsService;
    private final AnalysisService analysisService;
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile String defaultPercolatorMappingSource;
    private volatile Map<String, DocumentMapper> mappers = ImmutableMap.of();
    private volatile FieldTypeLookup fieldTypes;
    private volatile Map<String, ObjectMapper> fullPathObjectMappers = new HashMap<String, ObjectMapper>();
    private boolean hasNested = false;
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private final List<DocumentTypeListener> typeListeners = new CopyOnWriteArrayList<DocumentTypeListener>();
    private volatile ImmutableMap<String, MappedFieldType> unmappedFieldTypes = ImmutableMap.of();
    private volatile Set<String> parentTypes = ImmutableSet.of();
    final MapperRegistry mapperRegistry;
    private static final Predicate<DocumentMapper> NOT_A_DEFAULT_DOC_MAPPER = new Predicate<DocumentMapper>(){

        @Override
        public boolean apply(DocumentMapper input) {
            return !MapperService.DEFAULT_MAPPING.equals(input.type());
        }
    };

    @Inject
    public MapperService(Index index, IndexSettingsService indexSettingsService, AnalysisService analysisService, SimilarityLookupService similarityLookupService, ScriptService scriptService, MapperRegistry mapperRegistry) {
        super(index, indexSettingsService.getSettings());
        this.indexSettings = indexSettingsService.getSettings();
        this.indexSettingsService = indexSettingsService;
        this.analysisService = analysisService;
        this.mapperRegistry = mapperRegistry;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(this.indexSettings, this, analysisService, similarityLookupService, scriptService, mapperRegistry);
        this.indexAnalyzer = new MapperAnalyzerWrapper(analysisService.defaultIndexAnalyzer(), INDEX_ANALYZER_EXTRACTOR);
        this.searchAnalyzer = new MapperAnalyzerWrapper(analysisService.defaultSearchAnalyzer(), SEARCH_ANALYZER_EXTRACTOR);
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper(analysisService.defaultSearchQuoteAnalyzer(), SEARCH_QUOTE_ANALYZER_EXTRACTOR);
        this.dynamic = this.indexSettings.getAsBoolean(INDEX_MAPPER_DYNAMIC_SETTING, (Boolean)true);
        this.defaultPercolatorMappingSource = "{\n\"_default_\":{\n\"properties\" : {\n\"query\" : {\n\"type\" : \"object\",\n\"enabled\" : false\n}\n}\n}\n}";
        this.defaultMappingSource = index.getName().equals(".scripts") ? "{\"_default_\": {\"properties\": {\"script\": { \"enabled\": false },\"template\": { \"enabled\": false }}}}" : "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("using dynamic[{}], default mapping source[{}], default percolator mapping source[{}]", this.dynamic, this.defaultMappingSource, this.defaultPercolatorMappingSource);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("using dynamic[{}]", this.dynamic);
        }
    }

    public MapperService(Index index, Settings indexSettings, AnalysisService analysisService, SimilarityLookupService similarityLookupService, ScriptService scriptService, MapperRegistry mapperRegistry) {
        this(index, new IndexSettingsService(index, indexSettings), analysisService, similarityLookupService, scriptService, mapperRegistry);
    }

    @Override
    public void close() {
        for (DocumentMapper documentMapper : this.mappers.values()) {
            documentMapper.close();
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public Iterable<DocumentMapper> docMappers(final boolean includingDefaultMapping) {
        return new Iterable<DocumentMapper>(){

            @Override
            public Iterator<DocumentMapper> iterator() {
                Iterator iterator = includingDefaultMapping ? MapperService.this.mappers.values().iterator() : Iterators.filter(MapperService.this.mappers.values().iterator(), NOT_A_DEFAULT_DOC_MAPPER);
                return Iterators.unmodifiableIterator(iterator);
            }
        };
    }

    public AnalysisService analysisService() {
        return this.analysisService;
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public void addTypeListener(DocumentTypeListener listener) {
        this.typeListeners.add(listener);
    }

    public void removeTypeListener(DocumentTypeListener listener) {
        this.typeListeners.remove(listener);
    }

    public static Map<String, Object> parseMapping(String mappingSource) throws Exception {
        try (XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, boolean updateAllTypes) throws MapperParsingException {
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                this.merge(DEFAULT_MAPPING, new CompressedXContent(XContentFactory.jsonBuilder().map(mappings.get(DEFAULT_MAPPING)).string()), MergeReason.MAPPING_UPDATE, updateAllTypes);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            if (entry.getKey().equals(DEFAULT_MAPPING)) continue;
            try {
                this.merge(entry.getKey(), new CompressedXContent(XContentFactory.jsonBuilder().map(entry.getValue()).string()), MergeReason.MAPPING_UPDATE, updateAllTypes);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason, boolean updateAllTypes) {
        if (DEFAULT_MAPPING.equals(type)) {
            DocumentMapper mapper = this.documentParser.parse(type, mappingSource);
            MapperService mapperService = this;
            synchronized (mapperService) {
                this.mappers = MapBuilder.newMapBuilder(this.mappers).put(type, mapper).map();
            }
            try {
                this.defaultMappingSource = mappingSource.string();
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("failed to un-compress", e);
            }
            return mapper;
        }
        MapperService mapperService = this;
        synchronized (mapperService) {
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && !this.mappers.containsKey(type);
            DocumentMapper mergeWith = this.parse(type, mappingSource, applyDefault);
            return this.merge(mergeWith, reason, updateAllTypes);
        }
    }

    private synchronized DocumentMapper merge(DocumentMapper mapper, MergeReason reason, boolean updateAllTypes) {
        DocumentMapper oldMapper;
        if (mapper.type().length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1) && mapper.type().length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] is too long; limit is length 255 but was [" + mapper.type().length() + "]");
        }
        if (mapper.type().charAt(0) == '_') {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] can't start with '_'");
        }
        if (mapper.type().contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include '#' in it");
        }
        if (mapper.type().contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include ',' in it");
        }
        if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1) && mapper.type().equals(mapper.parentFieldMapper().type())) {
            throw new IllegalArgumentException("The [_parent.type] option can't point to the same type");
        }
        if (this.typeNameStartsWithIllegalDot(mapper)) {
            if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1)) {
                throw new IllegalArgumentException("mapping type name [" + mapper.type() + "] must not start with a '.'");
            }
            this.logger.warn("Type [{}] starts with a '.', it is recommended not to start a type name with a '.'", mapper.type());
        }
        if (reason == MergeReason.MAPPING_UPDATE) {
            if (mapper.timestampFieldMapper().enabled()) {
                this.deprecationLogger.deprecated("[_timestamp] will be removed in 5.0. As a replacement, you should explicitly populate a date field with the current timestamp in your documents.", new Object[0]);
            }
            if (mapper.TTLFieldMapper().enabled()) {
                this.deprecationLogger.deprecated("[_ttl] will be removed in 5.0. As a replacement, you should use time based indexes or cron a delete-by-query with a range query on a timestamp field.", new Object[0]);
            }
        }
        DocumentMapper newMapper = (oldMapper = this.mappers.get(mapper.type())) != null ? oldMapper.merge(mapper.mapping(), updateAllTypes) : mapper;
        ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
        Collections.addAll(fieldMappers, newMapper.mapping().metadataMappers);
        MapperUtils.collect(newMapper.mapping().root(), objectMappers, fieldMappers);
        this.checkFieldUniqueness(newMapper.type(), objectMappers, fieldMappers);
        this.checkObjectsCompatibility(newMapper.type(), objectMappers, fieldMappers, updateAllTypes);
        FieldTypeLookup fieldTypes = this.fieldTypes.copyAndAddAll(newMapper.type(), fieldMappers, updateAllTypes);
        boolean hasNested = this.hasNested;
        Map<String, ObjectMapper> fullPathObjectMappers = new HashMap<String, ObjectMapper>(this.fullPathObjectMappers);
        for (ObjectMapper objectMapper : objectMappers) {
            fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
            if (!objectMapper.nested().isNested()) continue;
            hasNested = true;
        }
        fullPathObjectMappers = Collections.unmodifiableMap(fullPathObjectMappers);
        if (reason == MergeReason.MAPPING_UPDATE) {
            this.checkNestedFieldsLimit(fullPathObjectMappers);
        }
        Set<String> parentTypes = this.parentTypes;
        if (oldMapper == null && newMapper.parentFieldMapper().active()) {
            parentTypes = new HashSet<String>(parentTypes.size() + 1);
            parentTypes.addAll(this.parentTypes);
            parentTypes.add(mapper.parentFieldMapper().type());
            parentTypes = Collections.unmodifiableSet(parentTypes);
        }
        Map<String, DocumentMapper> mappers = new HashMap<String, DocumentMapper>(this.mappers);
        mappers.put(newMapper.type(), newMapper);
        for (Map.Entry entry : mappers.entrySet()) {
            if (((String)entry.getKey()).equals(DEFAULT_MAPPING)) continue;
            DocumentMapper m = (DocumentMapper)entry.getValue();
            m = m.updateFieldType(fieldTypes.fullNameToFieldType);
            entry.setValue(m);
        }
        mappers = Collections.unmodifiableMap(mappers);
        this.mappers = mappers;
        this.fieldTypes = fieldTypes;
        this.hasNested = hasNested;
        this.fullPathObjectMappers = fullPathObjectMappers;
        this.parentTypes = parentTypes;
        if (oldMapper == null) {
            for (DocumentTypeListener documentTypeListener : this.typeListeners) {
                documentTypeListener.beforeCreate(mapper);
            }
        }
        assert (this.assertSerialization(newMapper));
        assert (this.assertMappersShareSameFieldType());
        return newMapper;
    }

    private boolean assertMappersShareSameFieldType() {
        for (DocumentMapper mapper : this.docMappers(false)) {
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            Collections.addAll(fieldMappers, mapper.mapping().metadataMappers);
            MapperUtils.collect(mapper.root(), new ArrayList<ObjectMapper>(), fieldMappers);
            for (FieldMapper fieldMapper : fieldMappers) {
                assert (fieldMapper.fieldType() == this.fieldTypes.get(fieldMapper.name())) : fieldMapper.name();
            }
        }
        return true;
    }

    private boolean typeNameStartsWithIllegalDot(DocumentMapper mapper) {
        return mapper.type().startsWith(".") && !".percolator".equals(mapper.type());
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    private void checkFieldUniqueness(String type, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers) {
        assert (Thread.holdsLock(this));
        HashSet<String> objectFullNames = new HashSet<String>();
        for (ObjectMapper objectMapper : objectMappers) {
            String fullPath = objectMapper.fullPath();
            if (objectFullNames.add(fullPath)) continue;
            throw new IllegalArgumentException("Object mapper [" + fullPath + "] is defined twice in mapping for type [" + type + "]");
        }
        Set uniqueFieldMappers = Collections.newSetFromMap(new IdentityHashMap());
        uniqueFieldMappers.addAll(fieldMappers);
        fieldMappers = uniqueFieldMappers;
        HashSet<String> fieldNames = new HashSet<String>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String name = fieldMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field in [" + type + "]");
            }
            if (fieldNames.add(name)) continue;
            throw new IllegalArgumentException("Field [" + name + "] is defined twice in [" + type + "]");
        }
        for (String fieldName : fieldNames) {
            if (!this.fullPathObjectMappers.containsKey(fieldName)) continue;
            throw new IllegalArgumentException("[" + fieldName + "] is defined as a field in mapping [" + type + "] but this name is already used for an object in other types");
        }
        for (String objectPath : objectFullNames) {
            if (this.fieldTypes.get(objectPath) == null) continue;
            throw new IllegalArgumentException("[" + objectPath + "] is defined as an object in mapping [" + type + "] but this name is already used for a field in other types");
        }
    }

    private void checkObjectsCompatibility(String type, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, boolean updateAllTypes) {
        assert (Thread.holdsLock(this));
        for (ObjectMapper newObjectMapper : objectMappers) {
            ObjectMapper existingObjectMapper = this.fullPathObjectMappers.get(newObjectMapper.fullPath());
            if (existingObjectMapper == null) continue;
            existingObjectMapper.merge(newObjectMapper, updateAllTypes);
        }
    }

    private void checkNestedFieldsLimit(Map<String, ObjectMapper> fullPathObjectMappers) {
        long allowedNestedFields = this.indexSettingsService.getSettings().getAsLong(INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING, (Long)50L);
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : fullPathObjectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (allowedNestedFields >= 0L && actualNestedFields > allowedNestedFields) {
            throw new IllegalArgumentException("Limit of nested fields [" + allowedNestedFields + "] in index [" + this.index().name() + "] has been exceeded");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        String defaultMappingSource = ".percolator".equals(mappingType) ? this.defaultPercolatorMappingSource : this.defaultMappingSource;
        return this.documentParser.parse(mappingType, mappingSource, applyDefault ? defaultMappingSource : null);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public Collection<String> types() {
        HashSet<String> types = new HashSet<String>(this.mappers.keySet());
        types.remove(DEFAULT_MAPPING);
        return Collections.unmodifiableSet(types);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index, (Throwable)new IllegalStateException("trying to auto create mapping, but dynamic mapping is disabled"), type);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    @Nullable
    public Query searchFilter(String ... types) {
        boolean filterPercolateType = this.hasMapping(".percolator");
        if (types != null && filterPercolateType) {
            for (String type : types) {
                if (!".percolator".equals(type)) continue;
                filterPercolateType = false;
                break;
            }
        }
        Query percolatorType = null;
        if (filterPercolateType) {
            percolatorType = this.documentMapper(".percolator").typeFilter();
        }
        if (types == null || types.length == 0) {
            if (this.hasNested && filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add(Queries.newNonNestedFilter(), BooleanClause.Occur.MUST);
                return new ConstantScoreQuery(bq.build());
            }
            if (this.hasNested) {
                return Queries.newNonNestedFilter();
            }
            if (filterPercolateType) {
                return new ConstantScoreQuery(Queries.not(percolatorType));
            }
            return null;
        }
        if (types.length == 1) {
            Query filter;
            DocumentMapper docMapper = this.documentMapper(types[0]);
            Query query = filter = docMapper != null ? docMapper.typeFilter() : new TermQuery(new Term("_type", types[0]));
            if (filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add(filter, BooleanClause.Occur.MUST);
                return new ConstantScoreQuery(bq.build());
            }
            return filter;
        }
        boolean useTermsFilter = true;
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                useTermsFilter = false;
                break;
            }
            if (docMapper.typeMapper().fieldType().indexOptions() != IndexOptions.NONE) continue;
            useTermsFilter = false;
            break;
        }
        if (useTermsFilter) {
            BytesRef[] typesBytes = new BytesRef[types.length];
            for (int i = 0; i < typesBytes.length; ++i) {
                typesBytes[i] = new BytesRef(types[i]);
            }
            TermsQuery termsFilter = new TermsQuery("_type", typesBytes);
            if (filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add(termsFilter, BooleanClause.Occur.MUST);
                return new ConstantScoreQuery(bq.build());
            }
            return termsFilter;
        }
        BooleanQuery.Builder typesBool = new BooleanQuery.Builder();
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                typesBool.add(new TermQuery(new Term("_type", type)), BooleanClause.Occur.SHOULD);
                continue;
            }
            typesBool.add(docMapper.typeFilter(), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery.Builder bool = new BooleanQuery.Builder();
        bool.add(typesBool.build(), BooleanClause.Occur.MUST);
        if (filterPercolateType) {
            bool.add(percolatorType, BooleanClause.Occur.MUST_NOT);
        }
        if (this.hasNested) {
            bool.add(Queries.newNonNestedFilter(), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery(bool.build());
    }

    public MappedFieldType indexName(String indexName) {
        return this.fieldTypes.getByIndexName(indexName);
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singletonList(pattern);
        }
        return this.fieldTypes.simpleMatchToIndexNames(pattern);
    }

    public Collection<String> simpleMatchToIndexNames(String pattern, @Nullable String[] types) {
        return this.simpleMatchToIndexNames(pattern);
    }

    public ObjectMapper getObjectMapper(String name, @Nullable String[] types) {
        return this.fullPathObjectMappers.get(name);
    }

    public MappedFieldType smartNameFieldType(String smartName) {
        MappedFieldType fieldType = this.fullName(smartName);
        if (fieldType != null) {
            return fieldType;
        }
        return this.indexName(smartName);
    }

    public MappedFieldType smartNameFieldType(String smartName, @Nullable String[] types) {
        return this.smartNameFieldType(smartName);
    }

    public MappedFieldType unmappedFieldType(String type) {
        ImmutableMap<String, MappedFieldType> unmappedFieldMappers = this.unmappedFieldTypes;
        MappedFieldType fieldType = unmappedFieldMappers.get(type);
        if (fieldType == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext(type);
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?, ?> builder = typeParser.parse("__anonymous_" + type, ImmutableMap.of(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings, new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            this.unmappedFieldTypes = ImmutableMap.builder().putAll(unmappedFieldMappers).put(type, fieldType).build();
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public ObjectMapper resolveClosestNestedObjectMapper(String fieldName) {
        int indexOf = fieldName.lastIndexOf(46);
        if (indexOf == -1) {
            return null;
        }
        do {
            String objectPath;
            ObjectMapper objectMapper;
            if ((objectMapper = this.fullPathObjectMappers.get(objectPath = fieldName.substring(0, indexOf))) == null) {
                indexOf = objectPath.lastIndexOf(46);
                continue;
            }
            if (objectMapper.nested().isNested()) {
                return objectMapper;
            }
            indexOf = objectPath.lastIndexOf(46);
        } while (indexOf != -1);
        return null;
    }

    public Set<String> getParentTypes() {
        return this.parentTypes;
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains(fieldName);
    }

    public static String[] getAllMetaFields() {
        return (String[])META_FIELDS.toArray(String.class);
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.smartNameFieldType(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE,
        MAPPING_RECOVERY;

    }
}

