/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.exp;

import org.apache.lucene.search.Explanation;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.DecayFunctionParser;

public class ExponentialDecayFunctionParser
extends DecayFunctionParser {
    public static final String[] NAMES = new String[]{"exp"};
    public static final DecayFunction decayFunction = new ExponentialDecayScoreFunction();

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public DecayFunction getDecayFunction() {
        return decayFunction;
    }

    static final class ExponentialDecayScoreFunction
    implements DecayFunction {
        ExponentialDecayScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return Math.exp(scale * value);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale) {
            return Explanation.match((float)this.evaluate(value, scale), "exp(- " + valueExpl + " * " + -1.0 * scale + ")", new Explanation[0]);
        }

        @Override
        public double processScale(double scale, double decay) {
            return Math.log(decay) / scale;
        }
    }
}

