/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.shard.VersionFieldUpgrader;

public final class ElasticsearchMergePolicy
extends MergePolicy {
    private static ESLogger logger = Loggers.getLogger(ElasticsearchMergePolicy.class);
    private final MergePolicy delegate;
    private volatile boolean upgradeInProgress;
    private volatile boolean upgradeOnlyAncientSegments;
    private static final int MAX_CONCURRENT_UPGRADE_MERGES = 5;

    public ElasticsearchMergePolicy(MergePolicy delegate) {
        this.delegate = delegate;
    }

    static CodecReader filter(CodecReader reader) throws IOException {
        reader = VersionFieldUpgrader.wrap(reader);
        return reader;
    }

    static MergePolicy.MergeSpecification upgradedMergeSpecification(MergePolicy.MergeSpecification spec) {
        if (spec == null) {
            return null;
        }
        IndexUpgraderMergeSpecification upgradedSpec = new IndexUpgraderMergeSpecification();
        for (MergePolicy.OneMerge merge : spec.merges) {
            ((MergePolicy.MergeSpecification)upgradedSpec).add(merge);
        }
        return upgradedSpec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findMerges(mergeTrigger, segmentInfos, writer));
    }

    private boolean shouldUpgrade(SegmentCommitInfo info) {
        org.apache.lucene.util.Version old = info.info.getVersion();
        org.apache.lucene.util.Version cur = Version.CURRENT.luceneVersion;
        assert (old.major <= cur.major);
        if (cur.major > old.major) {
            return true;
        }
        return !this.upgradeOnlyAncientSegments && cur.minor > old.minor;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        if (this.upgradeInProgress) {
            IndexUpgraderMergeSpecification spec = new IndexUpgraderMergeSpecification();
            for (SegmentCommitInfo info : segmentInfos) {
                if (this.shouldUpgrade(info)) {
                    logger.debug("Adding segment " + info.info.name + " to be upgraded", new Object[0]);
                    ((MergePolicy.MergeSpecification)spec).add(new MergePolicy.OneMerge(Collections.singletonList(info)));
                }
                if (spec.merges.size() != 5) continue;
                logger.debug("Returning " + spec.merges.size() + " merges for upgrade", new Object[0]);
                return spec;
            }
            if (!spec.merges.isEmpty()) {
                logger.debug("Returning " + spec.merges.size() + " merges for end of upgrade", new Object[0]);
                return spec;
            }
            this.upgradeInProgress = false;
        }
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return ElasticsearchMergePolicy.upgradedMergeSpecification(this.delegate.findForcedDeletesMerges(segmentInfos, writer));
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segments, SegmentCommitInfo newSegment, IndexWriter writer) throws IOException {
        return this.delegate.useCompoundFile(segments, newSegment, writer);
    }

    public void setUpgradeInProgress(boolean upgrade, boolean onlyAncientSegments) {
        this.upgradeInProgress = upgrade;
        this.upgradeOnlyAncientSegments = onlyAncientSegments;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.delegate + ")";
    }

    static class IndexUpgraderMergeSpecification
    extends MergePolicy.MergeSpecification {
        IndexUpgraderMergeSpecification() {
        }

        @Override
        public void add(MergePolicy.OneMerge merge) {
            super.add(new IndexUpgraderOneMerge(merge.segments));
        }

        @Override
        public String segString(Directory dir) {
            return "IndexUpgraderMergeSpec[" + super.segString(dir) + "]";
        }
    }

    static class IndexUpgraderOneMerge
    extends MergePolicy.OneMerge {
        public IndexUpgraderOneMerge(List<SegmentCommitInfo> segments) {
            super(segments);
        }

        @Override
        public List<CodecReader> getMergeReaders() throws IOException {
            ArrayList<CodecReader> newReaders = new ArrayList<CodecReader>();
            for (CodecReader reader : super.getMergeReaders()) {
                newReaders.add(ElasticsearchMergePolicy.filter(reader));
            }
            return newReaders;
        }
    }
}

