/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.WriteCode;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.mustache.CustomReflectionObjectHandler;

public class CustomMustacheFactory
extends DefaultMustacheFactory {
    private final Encoder encoder;

    public CustomMustacheFactory(boolean escaping) {
        this.setObjectHandler((ObjectHandler)new CustomReflectionObjectHandler());
        this.encoder = escaping ? new JsonEscapeEncoder() : new NoEscapeEncoder();
    }

    public void encode(String value, Writer writer) {
        this.encoder.accept(value, writer);
    }

    public MustacheVisitor createMustacheVisitor() {
        return new CustomMustacheVisitor(this);
    }

    static interface Encoder {
        public void accept(String var1, Writer var2);
    }

    class JsonEscapeEncoder
    implements Encoder {
        JsonEscapeEncoder() {
        }

        @Override
        public void accept(String s, Writer writer) {
            try {
                writer.write(JsonStringEncoder.getInstance().quoteAsString(s));
            }
            catch (IOException e) {
                throw new MustacheException("Failed to escape and encode value: " + s);
            }
        }
    }

    class NoEscapeEncoder
    implements Encoder {
        NoEscapeEncoder() {
        }

        @Override
        public void accept(String s, Writer writer) {
            try {
                writer.write(s);
            }
            catch (IOException e) {
                throw new MustacheException("Failed to encode value: " + s);
            }
        }
    }

    static class CustomJoinerCode
    extends JoinerCode {
        private static final Pattern PATTERN = Pattern.compile("^(?:join delimiter='(.*)')$");

        public CustomJoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CustomJoinerCode.extractDelimiter(variable));
        }

        private static String extractDelimiter(String variable) {
            Matcher matcher = PATTERN.matcher(variable);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new MustacheException("Failed to extract delimiter for join function");
        }

        static boolean match(String variable) {
            return PATTERN.matcher(variable).matches();
        }
    }

    static class JoinerCode
    extends CustomCode {
        protected static final String CODE = "join";
        private static final String DEFAULT_DELIMITER = ",";
        private final String delimiter;

        public JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String delimiter) {
            super(tc, df, mustache, CODE);
            this.delimiter = delimiter;
        }

        public JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache) {
            this(tc, df, mustache, DEFAULT_DELIMITER);
        }

        @Override
        protected Function<String, String> createFunction(final Object resolved) {
            return new Function(){

                public Object apply(Object s) {
                    if (s == null) {
                        return null;
                    }
                    if (resolved instanceof Iterable) {
                        StringBuilder joiner = new StringBuilder();
                        Iterator it = ((Iterable)resolved).iterator();
                        while (it.hasNext()) {
                            joiner.append(JoinerCode.this.oh.stringify(it.next()));
                            if (!it.hasNext()) continue;
                            joiner.append(JoinerCode.this.delimiter);
                        }
                        return joiner.toString();
                    }
                    return s;
                }
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    static class ToJsonCode
    extends CustomCode {
        private static final String CODE = "toJson";

        public ToJsonCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CODE);
            if (!CODE.equalsIgnoreCase(variable)) {
                throw new MustacheException("Mismatch function code [toJson] cannot be applied to [" + variable + "]");
            }
        }

        @Override
        protected Function<String, String> createFunction(final Object resolved) {
            return new Function(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public String apply(Object s) {
                    if (resolved == null) {
                        return null;
                    }
                    try (XContentBuilder builder = XContentBuilder.builder(XContentType.JSON.xContent());){
                        if (resolved instanceof Iterable) {
                            builder.startArray();
                            for (Object o : (Iterable)resolved) {
                                builder.value(o);
                            }
                            builder.endArray();
                        } else {
                            if (!(resolved instanceof Map)) {
                                String string = ToJsonCode.this.oh.stringify(resolved);
                                return string;
                            }
                            builder.map((Map)resolved);
                        }
                        String string = builder.string();
                        return string;
                    }
                    catch (IOException e) {
                        throw new MustacheException("Failed to convert object to JSON", (Throwable)e);
                    }
                }
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    static abstract class CustomCode
    extends IterableCode {
        private final String code;

        public CustomCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String code) {
            super(tc, df, mustache, CustomCode.extractVariableName(code, mustache, tc));
            this.code = Objects.requireNonNull(code);
        }

        public Writer execute(Writer writer, Object[] scopes) {
            Object resolved = this.get(scopes);
            writer = this.handle(writer, this.createFunction(resolved), scopes);
            this.appendText(writer);
            return writer;
        }

        protected void tag(Writer writer, String tag) throws IOException {
            writer.write(this.tc.startChars());
            writer.write(tag);
            writer.write(this.code);
            writer.write(this.tc.endChars());
        }

        protected abstract Function createFunction(Object var1);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static String extractVariableName(String fn, Mustache mustache, TemplateContext tc) {
            Code[] codes = mustache.getCodes();
            if (codes == null) throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
            if (codes.length != 1) {
                throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
            }
            try (StringWriter capture = new StringWriter();){
                if (codes[0] instanceof WriteCode) {
                    codes[0].execute((Writer)capture, Collections.emptyList());
                    String string = capture.toString();
                    return string;
                }
                codes[0].identity((Writer)capture);
                String string = capture.toString();
                return string;
            }
            catch (IOException e) {
                throw new MustacheException("Exception while parsing mustache function [" + fn + "] at line " + tc.line(), (Throwable)e);
            }
        }
    }

    class CustomMustacheVisitor
    extends DefaultMustacheVisitor {
        public CustomMustacheVisitor(DefaultMustacheFactory df) {
            super(df);
        }

        public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
            if (ToJsonCode.match(variable)) {
                this.list.add(new ToJsonCode(templateContext, this.df, mustache, variable));
            } else if (JoinerCode.match(variable)) {
                this.list.add(new JoinerCode(templateContext, this.df, mustache));
            } else if (CustomJoinerCode.match(variable)) {
                this.list.add(new CustomJoinerCode(templateContext, this.df, mustache, variable));
            } else {
                this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
            }
        }
    }
}

