/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service.impl;

import io.atomix.primitive.service.BackupOutput;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferOutput;
import io.atomix.storage.buffer.Bytes;
import io.atomix.utils.serializer.Serializer;
import java.nio.charset.Charset;

public class DefaultBackupOutput
implements BackupOutput {
    private final BufferOutput<?> output;
    private final Serializer serializer;

    public DefaultBackupOutput(BufferOutput<?> output, Serializer serializer) {
        this.output = output;
        this.serializer = serializer;
    }

    @Override
    public <U> BackupOutput writeObject(U object) {
        this.output.writeObject(object, o -> o != null ? this.serializer.encode(o) : null);
        return this;
    }

    public BackupOutput write(Bytes bytes) {
        this.output.write(bytes);
        return this;
    }

    public BackupOutput write(byte[] bytes) {
        this.output.write(bytes);
        return this;
    }

    public BackupOutput write(Bytes bytes, int offset, int length) {
        this.output.write(bytes, offset, length);
        return this;
    }

    public BackupOutput write(byte[] bytes, int offset, int length) {
        this.output.write(bytes, offset, length);
        return this;
    }

    public BackupOutput write(Buffer buffer) {
        this.output.write(buffer);
        return this;
    }

    public BackupOutput writeByte(int b) {
        this.output.writeByte(b);
        return this;
    }

    public BackupOutput writeUnsignedByte(int b) {
        this.output.writeUnsignedByte(b);
        return this;
    }

    public BackupOutput writeChar(char c) {
        this.output.writeChar(c);
        return this;
    }

    public BackupOutput writeShort(short s) {
        this.output.writeShort(s);
        return this;
    }

    public BackupOutput writeUnsignedShort(int s) {
        this.output.writeUnsignedShort(s);
        return this;
    }

    public BackupOutput writeMedium(int m) {
        this.output.writeMedium(m);
        return this;
    }

    public BackupOutput writeUnsignedMedium(int m) {
        this.output.writeUnsignedMedium(m);
        return this;
    }

    public BackupOutput writeInt(int i) {
        this.output.writeInt(i);
        return this;
    }

    public BackupOutput writeUnsignedInt(long i) {
        this.output.writeUnsignedInt(i);
        return this;
    }

    public BackupOutput writeLong(long l) {
        this.output.writeLong(l);
        return this;
    }

    public BackupOutput writeFloat(float f) {
        this.output.writeFloat(f);
        return this;
    }

    public BackupOutput writeDouble(double d) {
        this.output.writeDouble(d);
        return this;
    }

    public BackupOutput writeBoolean(boolean b) {
        this.output.writeBoolean(b);
        return this;
    }

    public BackupOutput writeString(String s) {
        this.output.writeString(s);
        return this;
    }

    public BackupOutput writeString(String s, Charset charset) {
        this.output.writeString(s, charset);
        return this;
    }

    public BackupOutput writeUTF8(String s) {
        this.output.writeUTF8(s);
        return this;
    }

    public BackupOutput flush() {
        this.output.flush();
        return this;
    }

    public void close() {
        this.output.close();
    }
}

