/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.KeyException;

public class KeyLengthException
extends KeyException {
    private final int expectedLength;
    private final Algorithm alg;

    public KeyLengthException(String message2) {
        super(message2);
        this.expectedLength = 0;
        this.alg = null;
    }

    public KeyLengthException(Algorithm alg) {
        this(0, alg);
    }

    public KeyLengthException(int expectedLength, Algorithm alg) {
        super(String.valueOf(expectedLength > 0 ? "The expected key length is " + expectedLength + " bits" : "Unexpected key length") + (alg != null ? " (for " + alg + " algorithm)" : ""));
        this.expectedLength = expectedLength;
        this.alg = alg;
    }

    public int getExpectedKeyLength() {
        return this.expectedLength;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }
}

