/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();
    private static final byte ZERO = 0;

    static byte getByte(long address2) {
        return PlatformDependent.getByte(address2);
    }

    static short getShort(long address2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
        }
        return (short)(PlatformDependent.getByte(address2) << 8 | PlatformDependent.getByte(address2 + 1L) & 0xFF);
    }

    static short getShortLE(long address2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(v) : v;
        }
        return (short)(PlatformDependent.getByte(address2) & 0xFF | PlatformDependent.getByte(address2 + 1L) << 8);
    }

    static int getUnsignedMedium(long address2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(address2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(address2 + 1L) : Short.reverseBytes(PlatformDependent.getShort(address2 + 1L))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(address2) & 0xFF) << 16 | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | PlatformDependent.getByte(address2 + 2L) & 0xFF;
    }

    static int getUnsignedMediumLE(long address2) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(address2) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(address2 + 1L)) : PlatformDependent.getShort(address2 + 1L)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(address2) & 0xFF | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 16;
    }

    static int getInt(long address2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return PlatformDependent.getByte(address2) << 24 | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 16 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 8 | PlatformDependent.getByte(address2 + 3L) & 0xFF;
    }

    static int getIntLE(long address2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(v) : v;
        }
        return PlatformDependent.getByte(address2) & 0xFF | (PlatformDependent.getByte(address2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(address2 + 2L) & 0xFF) << 16 | PlatformDependent.getByte(address2 + 3L) << 24;
    }

    static long getLong(long address2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return (long)PlatformDependent.getByte(address2) << 56 | ((long)PlatformDependent.getByte(address2 + 1L) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(address2 + 2L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(address2 + 3L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(address2 + 4L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(address2 + 5L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(address2 + 6L) & 0xFFL) << 8 | (long)PlatformDependent.getByte(address2 + 7L) & 0xFFL;
    }

    static long getLongLE(long address2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(address2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(v) : v;
        }
        return (long)PlatformDependent.getByte(address2) & 0xFFL | ((long)PlatformDependent.getByte(address2 + 1L) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(address2 + 2L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(address2 + 3L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(address2 + 4L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(address2 + 5L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(address2 + 6L) & 0xFFL) << 48 | (long)PlatformDependent.getByte(address2 + 7L) << 56;
    }

    static void setByte(long address2, int value2) {
        PlatformDependent.putByte(address2, (byte)value2);
    }

    static void setShort(long address2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value2 : Short.reverseBytes((short)value2));
        } else {
            PlatformDependent.putByte(address2, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 1L, (byte)value2);
        }
    }

    static void setShortLE(long address2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value2) : (short)value2);
        } else {
            PlatformDependent.putByte(address2, (byte)value2);
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 8));
        }
    }

    static void setMedium(long address2, int value2) {
        PlatformDependent.putByte(address2, (byte)(value2 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(address2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value2 : Short.reverseBytes((short)value2));
        } else {
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)value2);
        }
    }

    static void setMediumLE(long address2, int value2) {
        PlatformDependent.putByte(address2, (byte)value2);
        if (UNALIGNED) {
            PlatformDependent.putShort(address2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value2 >>> 8)) : (short)(value2 >>> 8));
        } else {
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value2 >>> 16));
        }
    }

    static void setInt(long address2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value2 : Integer.reverseBytes(value2));
        } else {
            PlatformDependent.putByte(address2, (byte)(value2 >>> 24));
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 16));
            PlatformDependent.putByte(address2 + 2L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 3L, (byte)value2);
        }
    }

    static void setIntLE(long address2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value2) : value2);
        } else {
            PlatformDependent.putByte(address2, (byte)value2);
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value2 >>> 16));
            PlatformDependent.putByte(address2 + 3L, (byte)(value2 >>> 24));
        }
    }

    static void setLong(long address2, long value2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value2 : Long.reverseBytes(value2));
        } else {
            PlatformDependent.putByte(address2, (byte)(value2 >>> 56));
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 48));
            PlatformDependent.putByte(address2 + 2L, (byte)(value2 >>> 40));
            PlatformDependent.putByte(address2 + 3L, (byte)(value2 >>> 32));
            PlatformDependent.putByte(address2 + 4L, (byte)(value2 >>> 24));
            PlatformDependent.putByte(address2 + 5L, (byte)(value2 >>> 16));
            PlatformDependent.putByte(address2 + 6L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 7L, (byte)value2);
        }
    }

    static void setLongLE(long address2, long value2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(address2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value2) : value2);
        } else {
            PlatformDependent.putByte(address2, (byte)value2);
            PlatformDependent.putByte(address2 + 1L, (byte)(value2 >>> 8));
            PlatformDependent.putByte(address2 + 2L, (byte)(value2 >>> 16));
            PlatformDependent.putByte(address2 + 3L, (byte)(value2 >>> 24));
            PlatformDependent.putByte(address2 + 4L, (byte)(value2 >>> 32));
            PlatformDependent.putByte(address2 + 5L, (byte)(value2 >>> 40));
            PlatformDependent.putByte(address2 + 6L, (byte)(value2 >>> 48));
            PlatformDependent.putByte(address2 + 7L, (byte)(value2 >>> 56));
        }
    }

    static byte getByte(byte[] array, int index2) {
        return PlatformDependent.getByte(array, index2);
    }

    static short getShort(byte[] array, int index2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
        }
        return (short)(PlatformDependent.getByte(array, index2) << 8 | PlatformDependent.getByte(array, index2 + 1) & 0xFF);
    }

    static short getShortLE(byte[] array, int index2) {
        if (UNALIGNED) {
            short v = PlatformDependent.getShort(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(v) : v;
        }
        return (short)(PlatformDependent.getByte(array, index2) & 0xFF | PlatformDependent.getByte(array, index2 + 1) << 8);
    }

    static int getUnsignedMedium(byte[] array, int index2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(array, index2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(array, index2 + 1) : Short.reverseBytes(PlatformDependent.getShort(array, index2 + 1))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(array, index2) & 0xFF) << 16 | (PlatformDependent.getByte(array, index2 + 1) & 0xFF) << 8 | PlatformDependent.getByte(array, index2 + 2) & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] array, int index2) {
        if (UNALIGNED) {
            return PlatformDependent.getByte(array, index2) & 0xFF | ((PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(PlatformDependent.getShort(array, index2 + 1)) : PlatformDependent.getShort(array, index2 + 1)) & 0xFFFF) << 8;
        }
        return PlatformDependent.getByte(array, index2) & 0xFF | (PlatformDependent.getByte(array, index2 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(array, index2 + 2) & 0xFF) << 16;
    }

    static int getInt(byte[] array, int index2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return PlatformDependent.getByte(array, index2) << 24 | (PlatformDependent.getByte(array, index2 + 1) & 0xFF) << 16 | (PlatformDependent.getByte(array, index2 + 2) & 0xFF) << 8 | PlatformDependent.getByte(array, index2 + 3) & 0xFF;
    }

    static int getIntLE(byte[] array, int index2) {
        if (UNALIGNED) {
            int v = PlatformDependent.getInt(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(v) : v;
        }
        return PlatformDependent.getByte(array, index2) & 0xFF | (PlatformDependent.getByte(array, index2 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(array, index2 + 2) & 0xFF) << 16 | PlatformDependent.getByte(array, index2 + 3) << 24;
    }

    static long getLong(byte[] array, int index2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return (long)PlatformDependent.getByte(array, index2) << 56 | ((long)PlatformDependent.getByte(array, index2 + 1) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(array, index2 + 2) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(array, index2 + 3) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(array, index2 + 4) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(array, index2 + 5) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(array, index2 + 6) & 0xFFL) << 8 | (long)PlatformDependent.getByte(array, index2 + 7) & 0xFFL;
    }

    static long getLongLE(byte[] array, int index2) {
        if (UNALIGNED) {
            long v = PlatformDependent.getLong(array, index2);
            return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(v) : v;
        }
        return (long)PlatformDependent.getByte(array, index2) & 0xFFL | ((long)PlatformDependent.getByte(array, index2 + 1) & 0xFFL) << 8 | ((long)PlatformDependent.getByte(array, index2 + 2) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(array, index2 + 3) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(array, index2 + 4) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(array, index2 + 5) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(array, index2 + 6) & 0xFFL) << 48 | (long)PlatformDependent.getByte(array, index2 + 7) << 56;
    }

    static void setByte(byte[] array, int index2, int value2) {
        PlatformDependent.putByte(array, index2, (byte)value2);
    }

    static void setShort(byte[] array, int index2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value2 : Short.reverseBytes((short)value2));
        } else {
            PlatformDependent.putByte(array, index2, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 1, (byte)value2);
        }
    }

    static void setShortLE(byte[] array, int index2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value2) : (short)value2);
        } else {
            PlatformDependent.putByte(array, index2, (byte)value2);
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 8));
        }
    }

    static void setMedium(byte[] array, int index2, int value2) {
        PlatformDependent.putByte(array, index2, (byte)(value2 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(array, index2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)value2 : Short.reverseBytes((short)value2));
        } else {
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 2, (byte)value2);
        }
    }

    static void setMediumLE(byte[] array, int index2, int value2) {
        PlatformDependent.putByte(array, index2, (byte)value2);
        if (UNALIGNED) {
            PlatformDependent.putShort(array, index2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(value2 >>> 8)) : (short)(value2 >>> 8));
        } else {
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 2, (byte)(value2 >>> 16));
        }
    }

    static void setInt(byte[] array, int index2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value2 : Integer.reverseBytes(value2));
        } else {
            PlatformDependent.putByte(array, index2, (byte)(value2 >>> 24));
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 16));
            PlatformDependent.putByte(array, index2 + 2, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 3, (byte)value2);
        }
    }

    static void setIntLE(byte[] array, int index2, int value2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value2) : value2);
        } else {
            PlatformDependent.putByte(array, index2, (byte)value2);
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 2, (byte)(value2 >>> 16));
            PlatformDependent.putByte(array, index2 + 3, (byte)(value2 >>> 24));
        }
    }

    static void setLong(byte[] array, int index2, long value2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value2 : Long.reverseBytes(value2));
        } else {
            PlatformDependent.putByte(array, index2, (byte)(value2 >>> 56));
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 48));
            PlatformDependent.putByte(array, index2 + 2, (byte)(value2 >>> 40));
            PlatformDependent.putByte(array, index2 + 3, (byte)(value2 >>> 32));
            PlatformDependent.putByte(array, index2 + 4, (byte)(value2 >>> 24));
            PlatformDependent.putByte(array, index2 + 5, (byte)(value2 >>> 16));
            PlatformDependent.putByte(array, index2 + 6, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 7, (byte)value2);
        }
    }

    static void setLongLE(byte[] array, int index2, long value2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(array, index2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value2) : value2);
        } else {
            PlatformDependent.putByte(array, index2, (byte)value2);
            PlatformDependent.putByte(array, index2 + 1, (byte)(value2 >>> 8));
            PlatformDependent.putByte(array, index2 + 2, (byte)(value2 >>> 16));
            PlatformDependent.putByte(array, index2 + 3, (byte)(value2 >>> 24));
            PlatformDependent.putByte(array, index2 + 4, (byte)(value2 >>> 32));
            PlatformDependent.putByte(array, index2 + 5, (byte)(value2 >>> 40));
            PlatformDependent.putByte(array, index2 + 6, (byte)(value2 >>> 48));
            PlatformDependent.putByte(array, index2 + 7, (byte)(value2 >>> 56));
        }
    }

    static void setZero(byte[] array, int index2, int length2) {
        if (length2 == 0) {
            return;
        }
        PlatformDependent.setMemory(array, index2, length2, (byte)0);
    }

    static ByteBuf copy(AbstractByteBuf buf, long addr2, int index2, int length2) {
        buf.checkIndex(index2, length2);
        ByteBuf copy = buf.alloc().directBuffer(length2, buf.maxCapacity());
        if (length2 != 0) {
            if (copy.hasMemoryAddress()) {
                PlatformDependent.copyMemory(addr2, copy.memoryAddress(), length2);
                copy.setIndex(0, length2);
            } else {
                copy.writeBytes(buf, index2, length2);
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setBytes(AbstractByteBuf buf, long addr2, int index2, InputStream in, int length2) throws IOException {
        buf.checkIndex(index2, length2);
        ByteBuf tmpBuf = buf.alloc().heapBuffer(length2);
        try {
            byte[] tmp = tmpBuf.array();
            int offset2 = tmpBuf.arrayOffset();
            int readBytes = in.read(tmp, offset2, length2);
            if (readBytes > 0) {
                PlatformDependent.copyMemory(tmp, offset2, addr2, (long)readBytes);
            }
            int n = readBytes;
            return n;
        }
        finally {
            tmpBuf.release();
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr2, int index2, ByteBuf dst, int dstIndex, int length2) {
        buf.checkIndex(index2, length2);
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(dstIndex, length2, dst.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(addr2, dst.memoryAddress() + (long)dstIndex, length2);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(addr2, dst.array(), dst.arrayOffset() + dstIndex, (long)length2);
        } else {
            dst.setBytes(dstIndex, buf, index2, length2);
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr2, int index2, byte[] dst, int dstIndex, int length2) {
        buf.checkIndex(index2, length2);
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(dstIndex, length2, dst.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (length2 != 0) {
            PlatformDependent.copyMemory(addr2, dst, dstIndex, (long)length2);
        }
    }

    static void getBytes(AbstractByteBuf buf, long addr2, int index2, ByteBuffer dst) {
        buf.checkIndex(index2, dst.remaining());
        if (dst.remaining() == 0) {
            return;
        }
        if (dst.isDirect()) {
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long dstAddress = PlatformDependent.directBufferAddress(dst);
            PlatformDependent.copyMemory(addr2, dstAddress + (long)dst.position(), dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(addr2, dst.array(), dst.arrayOffset() + dst.position(), (long)dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else {
            dst.put(buf.nioBuffer());
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr2, int index2, ByteBuf src, int srcIndex, int length2) {
        buf.checkIndex(index2, length2);
        ObjectUtil.checkNotNull(src, "src");
        if (MathUtil.isOutOfBounds(srcIndex, length2, src.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex);
        }
        if (length2 != 0) {
            if (src.hasMemoryAddress()) {
                PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, addr2, length2);
            } else if (src.hasArray()) {
                PlatformDependent.copyMemory(src.array(), src.arrayOffset() + srcIndex, addr2, (long)length2);
            } else {
                src.getBytes(srcIndex, buf, index2, length2);
            }
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr2, int index2, byte[] src, int srcIndex, int length2) {
        buf.checkIndex(index2, length2);
        if (length2 != 0) {
            PlatformDependent.copyMemory(src, srcIndex, addr2, (long)length2);
        }
    }

    static void setBytes(AbstractByteBuf buf, long addr2, int index2, ByteBuffer src) {
        int length2 = src.remaining();
        if (length2 == 0) {
            return;
        }
        if (src.isDirect()) {
            buf.checkIndex(index2, length2);
            long srcAddress = PlatformDependent.directBufferAddress(src);
            PlatformDependent.copyMemory(srcAddress + (long)src.position(), addr2, length2);
            src.position(src.position() + length2);
        } else if (src.hasArray()) {
            buf.checkIndex(index2, length2);
            PlatformDependent.copyMemory(src.array(), src.arrayOffset() + src.position(), addr2, (long)length2);
            src.position(src.position() + length2);
        } else if (length2 < 8) {
            UnsafeByteBufUtil.setSingleBytes(buf, addr2, index2, src, length2);
        } else {
            assert (buf.nioBufferCount() == 1);
            ByteBuffer internalBuffer = buf.internalNioBuffer(index2, length2);
            internalBuffer.put(src);
        }
    }

    private static void setSingleBytes(AbstractByteBuf buf, long addr2, int index2, ByteBuffer src, int length2) {
        buf.checkIndex(index2, length2);
        int srcPosition = src.position();
        int srcLimit = src.limit();
        long dstAddr = addr2;
        for (int srcIndex = srcPosition; srcIndex < srcLimit; ++srcIndex) {
            byte value2 = src.get(srcIndex);
            PlatformDependent.putByte(dstAddr, value2);
            ++dstAddr;
        }
        src.position(srcLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBytes(AbstractByteBuf buf, long addr2, int index2, OutputStream out, int length2) throws IOException {
        buf.checkIndex(index2, length2);
        if (length2 != 0) {
            int len = Math.min(length2, 8192);
            if (len <= 1024 || !buf.alloc().isDirectBufferPooled()) {
                UnsafeByteBufUtil.getBytes(addr2, ByteBufUtil.threadLocalTempArray(len), 0, len, out, length2);
            } else {
                ByteBuf tmpBuf = buf.alloc().heapBuffer(len);
                try {
                    byte[] tmp = tmpBuf.array();
                    int offset2 = tmpBuf.arrayOffset();
                    UnsafeByteBufUtil.getBytes(addr2, tmp, offset2, len, out, length2);
                }
                finally {
                    tmpBuf.release();
                }
            }
        }
    }

    private static void getBytes(long inAddr, byte[] in, int inOffset, int inLen, OutputStream out, int outLen) throws IOException {
        int len;
        do {
            len = Math.min(inLen, outLen);
            PlatformDependent.copyMemory(inAddr, in, inOffset, (long)len);
            out.write(in, inOffset, len);
            inAddr += (long)len;
        } while ((outLen -= len) > 0);
    }

    static void setZero(long addr2, int length2) {
        if (length2 == 0) {
            return;
        }
        PlatformDependent.setMemory(addr2, length2, (byte)0);
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator alloc2, int initialCapacity, int maxCapacity) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(alloc2, initialCapacity, maxCapacity);
        }
        return new UnpooledUnsafeDirectByteBuf(alloc2, initialCapacity, maxCapacity);
    }

    private UnsafeByteBufUtil() {
    }
}

