/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.Utils;

public class PercentCodec
implements BinaryEncoder,
BinaryDecoder {
    private static final byte ESCAPE_CHAR = 37;
    private final BitSet alwaysEncodeChars = new BitSet();
    private final boolean plusForSpace;
    private int alwaysEncodeCharsMin = Integer.MAX_VALUE;
    private int alwaysEncodeCharsMax = Integer.MIN_VALUE;

    public PercentCodec() {
        this.plusForSpace = false;
        this.insertAlwaysEncodeChar((byte)37);
    }

    public PercentCodec(byte[] alwaysEncodeChars, boolean plusForSpace) {
        this.plusForSpace = plusForSpace;
        this.insertAlwaysEncodeChars(alwaysEncodeChars);
    }

    private void insertAlwaysEncodeChars(byte[] alwaysEncodeCharsArray) {
        if (alwaysEncodeCharsArray != null) {
            for (byte b : alwaysEncodeCharsArray) {
                this.insertAlwaysEncodeChar(b);
            }
        }
        this.insertAlwaysEncodeChar((byte)37);
    }

    private void insertAlwaysEncodeChar(byte b) {
        this.alwaysEncodeChars.set(b);
        if (b < this.alwaysEncodeCharsMin) {
            this.alwaysEncodeCharsMin = b;
        }
        if (b > this.alwaysEncodeCharsMax) {
            this.alwaysEncodeCharsMax = b;
        }
    }

    @Override
    public byte[] encode(byte[] bytes2) throws EncoderException {
        boolean willEncode;
        if (bytes2 == null) {
            return null;
        }
        int expectedEncodingBytes = this.expectedEncodingBytes(bytes2);
        boolean bl = willEncode = expectedEncodingBytes != bytes2.length;
        if (willEncode || this.plusForSpace && this.containsSpace(bytes2)) {
            return this.doEncode(bytes2, expectedEncodingBytes, willEncode);
        }
        return bytes2;
    }

    private byte[] doEncode(byte[] bytes2, int expectedLength, boolean willEncode) {
        ByteBuffer buffer = ByteBuffer.allocate(expectedLength);
        for (byte b : bytes2) {
            if (willEncode && this.canEncode(b)) {
                byte bb = b;
                if (bb < 0) {
                    bb = (byte)(256 + bb);
                }
                char hex1 = Utils.hexDigit(bb >> 4);
                char hex2 = Utils.hexDigit(bb);
                buffer.put((byte)37);
                buffer.put((byte)hex1);
                buffer.put((byte)hex2);
                continue;
            }
            if (this.plusForSpace && b == 32) {
                buffer.put((byte)43);
                continue;
            }
            buffer.put(b);
        }
        return buffer.array();
    }

    private int expectedEncodingBytes(byte[] bytes2) {
        int byteCount = 0;
        for (byte b : bytes2) {
            byteCount += this.canEncode(b) ? 3 : 1;
        }
        return byteCount;
    }

    private boolean containsSpace(byte[] bytes2) {
        for (byte b : bytes2) {
            if (b != 32) continue;
            return true;
        }
        return false;
    }

    private boolean canEncode(byte c) {
        return !this.isAsciiChar(c) || this.inAlwaysEncodeCharsRange(c) && this.alwaysEncodeChars.get(c);
    }

    private boolean inAlwaysEncodeCharsRange(byte c) {
        return c >= this.alwaysEncodeCharsMin && c <= this.alwaysEncodeCharsMax;
    }

    private boolean isAsciiChar(byte c) {
        return c >= 0;
    }

    @Override
    public byte[] decode(byte[] bytes2) throws DecoderException {
        if (bytes2 == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.expectedDecodingBytes(bytes2));
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            byte b = bytes2[i2];
            if (b == 37) {
                try {
                    int u = Utils.digit16(bytes2[++i2]);
                    int l = Utils.digit16(bytes2[++i2]);
                    buffer.put((byte)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid percent decoding: ", e);
                }
            }
            if (this.plusForSpace && b == 43) {
                buffer.put((byte)32);
                continue;
            }
            buffer.put(b);
        }
        return buffer.array();
    }

    private int expectedDecodingBytes(byte[] bytes2) {
        int byteCount = 0;
        int i2 = 0;
        while (i2 < bytes2.length) {
            byte b;
            i2 += (b = bytes2[i2]) == 37 ? 3 : 1;
            ++byteCount;
        }
        return byteCount;
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.encode((byte[])obj);
        }
        throw new EncoderException("Objects of type " + obj.getClass().getName() + " cannot be Percent encoded");
    }

    @Override
    public Object decode(Object obj) throws DecoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.decode((byte[])obj);
        }
        throw new DecoderException("Objects of type " + obj.getClass().getName() + " cannot be Percent decoded");
    }
}

