/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName, false);
    }

    public FileWriterWithEncoding(String fileName, String charsetName, boolean append2) throws IOException {
        this(new File(fileName), charsetName, append2);
    }

    public FileWriterWithEncoding(String fileName, Charset charset) throws IOException {
        this(new File(fileName), charset, false);
    }

    public FileWriterWithEncoding(String fileName, Charset charset, boolean append2) throws IOException {
        this(new File(fileName), charset, append2);
    }

    public FileWriterWithEncoding(String fileName, CharsetEncoder encoding2) throws IOException {
        this(new File(fileName), encoding2, false);
    }

    public FileWriterWithEncoding(String fileName, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this(new File(fileName), charsetEncoder, append2);
    }

    public FileWriterWithEncoding(File file2, String charsetName) throws IOException {
        this(file2, charsetName, false);
    }

    public FileWriterWithEncoding(File file2, String charsetName, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, charsetName, append2);
    }

    public FileWriterWithEncoding(File file2, Charset charset) throws IOException {
        this(file2, charset, false);
    }

    public FileWriterWithEncoding(File file2, Charset encoding2, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append2);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder) throws IOException {
        this(file2, charsetEncoder, false);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder charsetEncoder, boolean append2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, charsetEncoder, append2);
    }

    private static Writer initWriter(File file2, Object encoding2, boolean append2) throws IOException {
        Objects.requireNonNull(file2, "file");
        Objects.requireNonNull(encoding2, "encoding");
        FileOutputStream stream = null;
        boolean fileExistedAlready = file2.exists();
        try {
            stream = new FileOutputStream(file2, append2);
            if (encoding2 instanceof Charset) {
                return new OutputStreamWriter((OutputStream)stream, (Charset)encoding2);
            }
            if (encoding2 instanceof CharsetEncoder) {
                return new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding2);
            }
            return new OutputStreamWriter((OutputStream)stream, (String)encoding2);
        }
        catch (IOException | RuntimeException ex) {
            try {
                IOUtils.close(stream);
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(char[] chr2) throws IOException {
        this.out.write(chr2);
    }

    @Override
    public void write(char[] chr2, int st, int end2) throws IOException {
        this.out.write(chr2, st, end2);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    @Override
    public void write(String str, int st, int end2) throws IOException {
        this.out.write(str, st, end2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

