/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.utils.InternalACLProvider;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class ZKPaths {
    public static final String PATH_SEPARATOR = "/";
    private static final Splitter PATH_SPLITTER = Splitter.on((String)"/").omitEmptyStrings();

    public static String fixForNamespace(String namespace, String path2) {
        return ZKPaths.fixForNamespace(namespace, path2, false);
    }

    public static String fixForNamespace(String namespace, String path2, boolean isSequential) {
        PathUtils.validatePath(path2, isSequential);
        if (namespace != null) {
            return ZKPaths.makePath(namespace, path2);
        }
        return path2;
    }

    public static String getNodeFromPath(String path2) {
        PathUtils.validatePath(path2);
        int i2 = path2.lastIndexOf(PATH_SEPARATOR);
        if (i2 < 0) {
            return path2;
        }
        if (i2 + 1 >= path2.length()) {
            return "";
        }
        return path2.substring(i2 + 1);
    }

    public static PathAndNode getPathAndNode(String path2) {
        PathUtils.validatePath(path2);
        int i2 = path2.lastIndexOf(PATH_SEPARATOR);
        if (i2 < 0) {
            return new PathAndNode(path2, "");
        }
        if (i2 + 1 >= path2.length()) {
            return new PathAndNode(PATH_SEPARATOR, "");
        }
        String node = path2.substring(i2 + 1);
        String parentPath = i2 > 0 ? path2.substring(0, i2) : PATH_SEPARATOR;
        return new PathAndNode(parentPath, node);
    }

    public static List<String> split(String path2) {
        PathUtils.validatePath(path2);
        return PATH_SPLITTER.splitToList((CharSequence)path2);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path2, true, null);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2, boolean makeLastNode) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path2, makeLastNode, null);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2, boolean makeLastNode, InternalACLProvider aclProvider) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path2);
        int pos2 = 1;
        do {
            String subPath;
            if ((pos2 = path2.indexOf(PATH_SEPARATOR, pos2 + 1)) == -1) {
                if (!makeLastNode) break;
                pos2 = path2.length();
            }
            if (zookeeper.exists(subPath = path2.substring(0, pos2), false) != null) continue;
            try {
                List<ACL> acl = null;
                if (aclProvider != null && (acl = aclProvider.getAclForPath(path2)) == null) {
                    acl = aclProvider.getDefaultAcl();
                }
                if (acl == null) {
                    acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
                }
                zookeeper.create(subPath, new byte[0], acl, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        } while (pos2 < path2.length());
    }

    public static void deleteChildren(ZooKeeper zookeeper, String path2, boolean deleteSelf) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path2);
        List<String> children = zookeeper.getChildren(path2, null);
        for (String child : children) {
            String fullPath = ZKPaths.makePath(path2, child);
            ZKPaths.deleteChildren(zookeeper, fullPath, true);
        }
        if (deleteSelf) {
            try {
                zookeeper.delete(path2, -1);
            }
            catch (KeeperException.NotEmptyException e) {
                ZKPaths.deleteChildren(zookeeper, path2, true);
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
        }
    }

    public static List<String> getSortedChildren(ZooKeeper zookeeper, String path2) throws InterruptedException, KeeperException {
        List<String> children = zookeeper.getChildren(path2, false);
        ArrayList sortedList = Lists.newArrayList(children);
        Collections.sort(sortedList);
        return sortedList;
    }

    public static String makePath(String parent, String child) {
        StringBuilder path2 = new StringBuilder();
        ZKPaths.joinPath(path2, parent, child);
        return path2.toString();
    }

    public static String makePath(String parent, String firstChild, String ... restChildren) {
        StringBuilder path2 = new StringBuilder();
        ZKPaths.joinPath(path2, parent, firstChild);
        if (restChildren == null) {
            return path2.toString();
        }
        for (String child : restChildren) {
            ZKPaths.joinPath(path2, "", child);
        }
        return path2.toString();
    }

    private static void joinPath(StringBuilder path2, String parent, String child) {
        if (parent != null && parent.length() > 0) {
            if (!parent.startsWith(PATH_SEPARATOR)) {
                path2.append(PATH_SEPARATOR);
            }
            if (parent.endsWith(PATH_SEPARATOR)) {
                path2.append(parent.substring(0, parent.length() - 1));
            } else {
                path2.append(parent);
            }
        }
        if (child == null || child.length() == 0 || child.equals(PATH_SEPARATOR)) {
            if (path2.length() == 0) {
                path2.append(PATH_SEPARATOR);
            }
            return;
        }
        path2.append(PATH_SEPARATOR);
        if (child.startsWith(PATH_SEPARATOR)) {
            child = child.substring(1);
        }
        if (child.endsWith(PATH_SEPARATOR)) {
            child = child.substring(0, child.length() - 1);
        }
        path2.append(child);
    }

    private ZKPaths() {
    }

    public static class PathAndNode {
        private final String path;
        private final String node;

        public PathAndNode(String path2, String node) {
            this.path = path2;
            this.node = node;
        }

        public String getPath() {
            return this.path;
        }

        public String getNode() {
            return this.node;
        }
    }
}

