/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;

class ArcFourHmacMd5Encryption
extends EncryptionEngine {
    ArcFourHmacMd5Encryption() {
    }

    @Override
    public EncryptionType getEncryptionType() {
        return EncryptionType.RC4_HMAC;
    }

    @Override
    public int getChecksumLength() {
        return 16;
    }

    @Override
    public int getConfounderLength() {
        return 8;
    }

    @Override
    public byte[] getDecryptedData(EncryptionKey key2, EncryptedData data, KeyUsage usage) throws KerberosException {
        return data.getCipher();
    }

    @Override
    public EncryptedData getEncryptedData(EncryptionKey key2, byte[] plainText, KeyUsage usage) {
        return new EncryptedData(this.getEncryptionType(), key2.getKeyVersion(), plainText);
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return this.processCipher(true, plainText, keyBytes);
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return this.processCipher(false, cipherText, keyBytes);
    }

    @Override
    public byte[] calculateIntegrity(byte[] data, byte[] key2, KeyUsage usage) {
        try {
            Mac digester = Mac.getInstance("HmacMD5");
            return digester.doFinal(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    private byte[] processCipher(boolean isEncrypt, byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = Cipher.getInstance("ARCFOUR");
            SecretKeySpec key2 = new SecretKeySpec(keyBytes, "ARCFOUR");
            if (isEncrypt) {
                cipher.init(1, key2);
            } else {
                cipher.init(2, key2);
            }
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }
}

