/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DesCbcMd5Encryption
extends EncryptionEngine {
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());
    private static final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    DesCbcMd5Encryption() {
    }

    @Override
    public EncryptionType getEncryptionType() {
        return EncryptionType.DES_CBC_MD5;
    }

    @Override
    public int getConfounderLength() {
        return 8;
    }

    @Override
    public int getChecksumLength() {
        return 16;
    }

    @Override
    public byte[] calculateIntegrity(byte[] data, byte[] key2, KeyUsage usage) {
        try {
            MessageDigest digester = MessageDigest.getInstance(LdapSecurityConstants.HASH_METHOD_MD5.getAlgorithm());
            return digester.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    @Override
    public byte[] getDecryptedData(EncryptionKey key2, EncryptedData data, KeyUsage usage) throws KerberosException {
        LOG_KRB.debug("Decrypting data using {}", (Object)key2);
        byte[] decryptedData = this.decrypt(data.getCipher(), key2.getKeyValue());
        byte[] oldChecksum = new byte[this.getChecksumLength()];
        System.arraycopy(decryptedData, this.getConfounderLength(), oldChecksum, 0, oldChecksum.length);
        for (int i2 = this.getConfounderLength(); i2 < this.getConfounderLength() + this.getChecksumLength(); ++i2) {
            decryptedData[i2] = 0;
        }
        byte[] newChecksum = this.calculateIntegrity(decryptedData, key2.getKeyValue(), usage);
        if (!Arrays.equals(oldChecksum, newChecksum)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        return this.removeLeadingBytes(decryptedData, this.getConfounderLength(), this.getChecksumLength());
    }

    @Override
    public EncryptedData getEncryptedData(EncryptionKey key2, byte[] plainText, KeyUsage usage) {
        byte[] conFounder = this.getRandomBytes(this.getConfounderLength());
        byte[] zeroedChecksum = new byte[this.getChecksumLength()];
        byte[] dataBytes = this.concatenateBytes(conFounder, this.concatenateBytes(zeroedChecksum, plainText));
        byte[] paddedDataBytes = this.padString(dataBytes);
        byte[] checksumBytes = this.calculateIntegrity(paddedDataBytes, null, usage);
        for (int i2 = this.getConfounderLength(); i2 < this.getConfounderLength() + this.getChecksumLength(); ++i2) {
            paddedDataBytes[i2] = checksumBytes[i2 - this.getConfounderLength()];
        }
        byte[] encryptedData = this.encrypt(paddedDataBytes, key2.getKeyValue());
        return new EncryptedData(this.getEncryptionType(), key2.getKeyVersion(), encryptedData);
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return this.processCipher(true, plainText, keyBytes);
    }

    @Override
    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return this.processCipher(false, cipherText, keyBytes);
    }

    private byte[] processCipher(boolean isEncrypt, byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            SecretKeySpec key2 = new SecretKeySpec(keyBytes, "DES");
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            if (isEncrypt) {
                cipher.init(1, (Key)key2, paramSpec);
            } else {
                cipher.init(2, (Key)key2, paramSpec);
            }
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }
}

