/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ByteBufferTag
implements Tag {
    private ByteBuffer buffer;
    private int offset;
    private int length;
    private byte type;

    public ByteBufferTag(ByteBuffer buffer, int offset2, int length2) {
        this.buffer = buffer;
        this.offset = offset2;
        this.length = length2;
        this.type = ByteBufferUtils.toByte(buffer, offset2 + 2);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int getValueOffset() {
        return this.offset + 3;
    }

    @Override
    public int getValueLength() {
        return this.length - 3;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] getValueArray() {
        throw new UnsupportedOperationException("Tag is backed by an off heap buffer. Use getValueByteBuffer()");
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        return this.buffer;
    }

    public String toString() {
        return "[Tag type : " + this.type + ", value : " + ByteBufferUtils.toStringBinary(this.buffer, this.getValueOffset(), this.getValueLength()) + "]";
    }
}

