/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class NamespaceDescriptor {
    public static final byte[] SYSTEM_NAMESPACE_NAME = Bytes.toBytes("hbase");
    public static final String SYSTEM_NAMESPACE_NAME_STR = Bytes.toString(SYSTEM_NAMESPACE_NAME);
    public static final byte[] DEFAULT_NAMESPACE_NAME = Bytes.toBytes("default");
    public static final String DEFAULT_NAMESPACE_NAME_STR = Bytes.toString(DEFAULT_NAMESPACE_NAME);
    public static final NamespaceDescriptor DEFAULT_NAMESPACE = NamespaceDescriptor.create(DEFAULT_NAMESPACE_NAME_STR).build();
    public static final NamespaceDescriptor SYSTEM_NAMESPACE = NamespaceDescriptor.create(SYSTEM_NAMESPACE_NAME_STR).build();
    public static final Set<String> RESERVED_NAMESPACES;
    public static final Set<byte[]> RESERVED_NAMESPACES_BYTES;
    private String name;
    private Map<String, String> configuration;
    public static final Comparator<NamespaceDescriptor> NAMESPACE_DESCRIPTOR_COMPARATOR;

    private NamespaceDescriptor() {
    }

    private NamespaceDescriptor(String name2) {
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationValue(String key2) {
        return this.configuration.get(key2);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public void setConfiguration(String key2, String value2) {
        if (value2 == null) {
            this.removeConfiguration(key2);
        } else {
            this.configuration.put(key2, value2);
        }
    }

    public void removeConfiguration(String key2) {
        this.configuration.remove(key2);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append('{');
        s2.append("NAME");
        s2.append(" => '");
        s2.append(this.name);
        s2.append("'");
        for (Map.Entry<String, String> e : this.configuration.entrySet()) {
            String key2 = e.getKey();
            String value2 = e.getValue();
            if (key2 == null) continue;
            s2.append(", ");
            s2.append(key2);
            s2.append(" => '");
            s2.append(value2);
            s2.append("'");
        }
        s2.append('}');
        return s2.toString();
    }

    public static Builder create(String name2) {
        return new Builder(name2);
    }

    public static Builder create(NamespaceDescriptor ns) {
        return new Builder(ns);
    }

    static {
        AbstractSet set = new HashSet<String>();
        set.add(DEFAULT_NAMESPACE_NAME_STR);
        set.add(SYSTEM_NAMESPACE_NAME_STR);
        RESERVED_NAMESPACES = Collections.unmodifiableSet(set);
        set = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (String name2 : RESERVED_NAMESPACES) {
            set.add(Bytes.toBytes(name2));
        }
        RESERVED_NAMESPACES_BYTES = Collections.unmodifiableSet(set);
        NAMESPACE_DESCRIPTOR_COMPARATOR = new Comparator<NamespaceDescriptor>(){

            @Override
            public int compare(NamespaceDescriptor namespaceDescriptor, NamespaceDescriptor namespaceDescriptor2) {
                return namespaceDescriptor.getName().compareTo(namespaceDescriptor2.getName());
            }
        };
    }

    @InterfaceAudience.Public
    public static class Builder {
        private String bName;
        private Map<String, String> bConfiguration = new TreeMap<String, String>();

        private Builder(NamespaceDescriptor ns) {
            this.bName = ns.name;
            this.bConfiguration = ns.configuration;
        }

        private Builder(String name2) {
            this.bName = name2;
        }

        public Builder addConfiguration(Map<String, String> configuration) {
            this.bConfiguration.putAll(configuration);
            return this;
        }

        public Builder addConfiguration(String key2, String value2) {
            this.bConfiguration.put(key2, value2);
            return this;
        }

        public Builder removeConfiguration(String key2) {
            this.bConfiguration.remove(key2);
            return this;
        }

        public NamespaceDescriptor build() {
            if (this.bName == null) {
                throw new IllegalArgumentException("A name has to be specified in a namespace.");
            }
            NamespaceDescriptor desc = new NamespaceDescriptor(this.bName);
            desc.configuration = this.bConfiguration;
            return desc;
        }
    }
}

