/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Cancellable;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CancellableRegionServerCallable<T>
extends ClientServiceCallable<T>
implements Cancellable {
    private final RetryingTimeTracker tracker;
    private final int rpcTimeout;

    CancellableRegionServerCallable(Connection connection, TableName tableName, byte[] row, RpcController rpcController, int rpcTimeout, RetryingTimeTracker tracker, int priority2) {
        super(connection, tableName, row, rpcController, priority2);
        this.rpcTimeout = rpcTimeout;
        this.tracker = tracker;
    }

    @Override
    public T call(int operationTimeout) throws IOException {
        if (this.isCancelled()) {
            return null;
        }
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        this.tracker.start();
        int remainingTime = this.tracker.getRemainingTime(operationTimeout);
        if (remainingTime <= 1) {
            throw new DoNotRetryIOException("Operation rpcTimeout");
        }
        return super.call(Math.min(this.rpcTimeout, remainingTime));
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (this.isCancelled()) {
            return;
        }
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        super.prepare(reload);
    }

    @Override
    protected void setStubByServiceName(ServerName serviceName) throws IOException {
        this.setStub(this.getConnection().getClient(serviceName));
    }

    @Override
    public void cancel() {
        this.getRpcController().startCancel();
    }

    @Override
    public boolean isCancelled() {
        return this.getRpcController().isCanceled();
    }

    protected ClientProtos.MultiResponse doMulti(ClientProtos.MultiRequest request) throws ServiceException {
        return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).multi(this.getRpcController(), request);
    }

    protected ClientProtos.ScanResponse doScan(ClientProtos.ScanRequest request) throws ServiceException {
        return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).scan(this.getRpcController(), request);
    }

    protected ClientProtos.PrepareBulkLoadResponse doPrepareBulkLoad(ClientProtos.PrepareBulkLoadRequest request) throws ServiceException {
        return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).prepareBulkLoad(this.getRpcController(), request);
    }

    protected ClientProtos.BulkLoadHFileResponse doBulkLoadHFile(ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).bulkLoadHFile(this.getRpcController(), request);
    }

    protected ClientProtos.CleanupBulkLoadResponse doCleanupBulkLoad(ClientProtos.CleanupBulkLoadRequest request) throws ServiceException {
        return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).cleanupBulkLoad(this.getRpcController(), request);
    }
}

