/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.CompressionState;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FastDiffDeltaEncoder
extends BufferedDataBlockEncoder {
    static final int MASK_TIMESTAMP_LENGTH = 7;
    static final int SHIFT_TIMESTAMP_LENGTH = 0;
    static final int FLAG_SAME_KEY_LENGTH = 8;
    static final int FLAG_SAME_VALUE_LENGTH = 16;
    static final int FLAG_SAME_TYPE = 32;
    static final int FLAG_SAME_VALUE = 64;

    private int findCommonTimestampPrefix(byte[] curTsBuf, byte[] prevTsBuf) {
        int commonPrefix;
        for (commonPrefix = 0; commonPrefix < 7 && curTsBuf[commonPrefix] == prevTsBuf[commonPrefix]; ++commonPrefix) {
        }
        return commonPrefix;
    }

    private void uncompressSingleKeyValue(DataInputStream source2, ByteBuffer out, FastDiffCompressionState state) throws IOException, EncoderBufferTooSmallException {
        byte flag = source2.readByte();
        int prevKeyLength = state.keyLength;
        if ((flag & 8) == 0) {
            state.keyLength = ByteBufferUtils.readCompressedInt(source2);
        }
        if ((flag & 0x10) == 0) {
            state.valueLength = ByteBufferUtils.readCompressedInt(source2);
        }
        int commonLength = ByteBufferUtils.readCompressedInt(source2);
        FastDiffDeltaEncoder.ensureSpace(out, state.keyLength + state.valueLength + 8);
        int kvPos = out.position();
        if (!state.isFirst()) {
            int keyRestLength;
            int common;
            int prevOffset;
            if ((flag & 0x10) == 0) {
                out.putInt(state.keyLength);
                out.putInt(state.valueLength);
                prevOffset = state.prevOffset + 8;
                common = commonLength;
            } else if ((flag & 8) != 0) {
                prevOffset = state.prevOffset;
                common = commonLength + 8;
            } else {
                out.putInt(state.keyLength);
                prevOffset = state.prevOffset + 4;
                common = commonLength + 4;
            }
            ByteBufferUtils.copyFromBufferToBuffer(out, out, prevOffset, common);
            if (commonLength < state.rowLength + 2) {
                int rowRestLength;
                int rowWithSizeLength;
                if (commonLength < 2) {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source2, 2 - commonLength);
                    rowWithSizeLength = out.getShort(out.position() - 2) + 2;
                    rowRestLength = rowWithSizeLength - 2;
                } else {
                    rowWithSizeLength = out.getShort(kvPos + 8) + 2;
                    rowRestLength = rowWithSizeLength - commonLength;
                }
                ByteBufferUtils.copyFromStreamToBuffer(out, source2, rowRestLength);
                ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + 2 + state.rowLength, state.familyLength + 1);
                state.rowLength = (short)(rowWithSizeLength - 2);
                keyRestLength = state.keyLength - rowWithSizeLength - state.familyLength - 10;
            } else {
                keyRestLength = state.keyLength - commonLength - 9;
            }
            ByteBufferUtils.copyFromStreamToBuffer(out, source2, keyRestLength);
            int prefixTimestamp = (flag & 7) >>> 0;
            ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevTimestampOffset, prefixTimestamp);
            state.prevTimestampOffset = out.position() - prefixTimestamp;
            ByteBufferUtils.copyFromStreamToBuffer(out, source2, 8 - prefixTimestamp);
            if ((flag & 0x20) != 0) {
                out.put(state.type);
                if ((flag & 0x40) != 0) {
                    ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + prevKeyLength, state.valueLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source2, state.valueLength);
                }
            } else {
                if ((flag & 0x40) != 0) {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source2, 1);
                    ByteBufferUtils.copyFromBufferToBuffer(out, out, state.prevOffset + 8 + prevKeyLength, state.valueLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(out, source2, state.valueLength + 1);
                }
                state.type = out.get(state.prevTimestampOffset + 8);
            }
        } else {
            state.decompressFirstKV(out, source2);
        }
        state.prevOffset = kvPos;
    }

    @Override
    public int internalEncode(Cell cell, HFileBlockDefaultEncodingContext encodingContext, DataOutputStream out) throws IOException {
        EncodingState state = encodingContext.getEncodingState();
        int size2 = this.compressSingleKeyValue(out, cell, state.prevCell);
        state.prevCell = cell;
        return size2 += this.afterEncodingKeyValue(cell, out, encodingContext);
    }

    private int compressSingleKeyValue(DataOutputStream out, Cell cell, Cell prevCell) throws IOException {
        int flag = 0;
        int kLength = KeyValueUtil.keyLength(cell);
        int vLength = cell.getValueLength();
        if (prevCell == null) {
            out.write(flag);
            ByteBufferUtils.putCompressedInt(out, kLength);
            ByteBufferUtils.putCompressedInt(out, vLength);
            ByteBufferUtils.putCompressedInt(out, 0);
            PrivateCellUtil.writeFlatKey(cell, out);
            PrivateCellUtil.writeValue(out, cell, cell.getValueLength());
        } else {
            int preKeyLength = KeyValueUtil.keyLength(prevCell);
            int preValLength = prevCell.getValueLength();
            int commonPrefix = PrivateCellUtil.findCommonPrefixInFlatKey(cell, prevCell, true, false);
            if (kLength == preKeyLength) {
                flag |= 8;
            }
            if (vLength == prevCell.getValueLength()) {
                flag |= 0x10;
            }
            if (cell.getTypeByte() == prevCell.getTypeByte()) {
                flag |= 0x20;
            }
            byte[] curTsBuf = Bytes.toBytes(cell.getTimestamp());
            int commonTimestampPrefix = this.findCommonTimestampPrefix(curTsBuf, Bytes.toBytes(prevCell.getTimestamp()));
            flag |= commonTimestampPrefix << 0;
            if (vLength == preValLength && PrivateCellUtil.matchingValue(cell, prevCell, vLength, preValLength)) {
                flag |= 0x40;
            }
            out.write(flag);
            if ((flag & 8) == 0) {
                ByteBufferUtils.putCompressedInt(out, kLength);
            }
            if ((flag & 0x10) == 0) {
                ByteBufferUtils.putCompressedInt(out, vLength);
            }
            ByteBufferUtils.putCompressedInt(out, commonPrefix);
            short rLen = cell.getRowLength();
            if (commonPrefix < rLen + 2) {
                PrivateCellUtil.writeRowKeyExcludingCommon(cell, rLen, commonPrefix, out);
                PrivateCellUtil.writeQualifier(out, cell, cell.getQualifierLength());
            } else {
                int commonQualPrefix = commonPrefix - (rLen + 2) - (cell.getFamilyLength() + 1);
                PrivateCellUtil.writeQualifierSkippingBytes(out, cell, cell.getQualifierLength(), commonQualPrefix);
            }
            out.write(curTsBuf, commonTimestampPrefix, 8 - commonTimestampPrefix);
            if ((flag & 0x20) == 0) {
                out.write(cell.getTypeByte());
            }
            if ((flag & 0x40) == 0) {
                PrivateCellUtil.writeValue(out, cell, vLength);
            }
        }
        return kLength + vLength + 8;
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source2, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source2.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        FastDiffCompressionState state = new FastDiffCompressionState();
        while (source2.available() > skipLastBytes) {
            this.uncompressSingleKeyValue(source2, buffer, state);
            this.afterDecodingKeyValue(source2, buffer, decodingCtx);
        }
        if (source2.available() != skipLastBytes) {
            throw new IllegalStateException("Read too much bytes.");
        }
        return buffer;
    }

    @Override
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        block.mark();
        block.position(5);
        int keyLength = ByteBuff.readCompressedInt(block);
        ByteBuff.readCompressedInt(block);
        ByteBuff.readCompressedInt(block);
        ByteBuffer key2 = block.asSubByteBuffer(keyLength).duplicate();
        block.reset();
        return this.createFirstKeyCell(key2, keyLength);
    }

    public String toString() {
        return FastDiffDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(HFileBlockDecodingContext decodingCtx) {
        return new FastDiffSeekerStateBufferedEncodedSeeker(decodingCtx);
    }

    private static class FastDiffSeekerStateBufferedEncodedSeeker
    extends BufferedDataBlockEncoder.BufferedEncodedSeeker<FastDiffSeekerState> {
        private FastDiffSeekerStateBufferedEncodedSeeker(HFileBlockDecodingContext decodingCtx) {
            super(decodingCtx);
        }

        private void decode(boolean isFirst) {
            byte flag = this.currentBuffer.get();
            if ((flag & 8) == 0) {
                if (!isFirst) {
                    System.arraycopy(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length, ((FastDiffSeekerState)this.current).prevTimestampAndType, 0, ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                }
                ((FastDiffSeekerState)this.current).keyLength = ByteBuff.readCompressedInt(this.currentBuffer);
            }
            if ((flag & 0x10) == 0) {
                ((FastDiffSeekerState)this.current).valueLength = ByteBuff.readCompressedInt(this.currentBuffer);
            }
            ((FastDiffSeekerState)this.current).lastCommonPrefix = ByteBuff.readCompressedInt(this.currentBuffer);
            ((FastDiffSeekerState)this.current).ensureSpaceForKey();
            if (isFirst) {
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
                ((FastDiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((FastDiffSeekerState)this.current).keyBuffer, 0) + 2;
                ((FastDiffSeekerState)this.current).familyLengthWithSize = ((FastDiffSeekerState)this.current).keyBuffer[((FastDiffSeekerState)this.current).rowLengthWithSize] + 1;
            } else if (((FastDiffSeekerState)this.current).lastCommonPrefix < 2) {
                int oldRowLengthWithSize = ((FastDiffSeekerState)this.current).rowLengthWithSize;
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, 2 - ((FastDiffSeekerState)this.current).lastCommonPrefix);
                ((FastDiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((FastDiffSeekerState)this.current).keyBuffer, 0) + 2;
                System.arraycopy(((FastDiffSeekerState)this.current).keyBuffer, oldRowLengthWithSize, ((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize, ((FastDiffSeekerState)this.current).familyLengthWithSize);
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, 2, ((FastDiffSeekerState)this.current).rowLengthWithSize - 2);
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize + ((FastDiffSeekerState)this.current).familyLengthWithSize, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).familyLengthWithSize - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
            } else if (((FastDiffSeekerState)this.current).lastCommonPrefix < ((FastDiffSeekerState)this.current).rowLengthWithSize) {
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).lastCommonPrefix);
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).rowLengthWithSize + ((FastDiffSeekerState)this.current).familyLengthWithSize, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).rowLengthWithSize - ((FastDiffSeekerState)this.current).familyLengthWithSize - ((FastDiffSeekerState)this.current).prevTimestampAndType.length);
            } else {
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, ((FastDiffSeekerState)this.current).lastCommonPrefix, ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length - ((FastDiffSeekerState)this.current).lastCommonPrefix);
            }
            int pos2 = ((FastDiffSeekerState)this.current).keyLength - ((FastDiffSeekerState)this.current).prevTimestampAndType.length;
            int commonTimestampPrefix = (flag & 7) >>> 0;
            if ((flag & 8) == 0) {
                System.arraycopy(((FastDiffSeekerState)this.current).prevTimestampAndType, 0, ((FastDiffSeekerState)this.current).keyBuffer, pos2, commonTimestampPrefix);
            }
            this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, pos2 += commonTimestampPrefix, 8 - commonTimestampPrefix);
            pos2 += 8 - commonTimestampPrefix;
            if ((flag & 0x20) == 0) {
                this.currentBuffer.get(((FastDiffSeekerState)this.current).keyBuffer, pos2, 1);
            } else if ((flag & 8) == 0) {
                ((FastDiffSeekerState)this.current).keyBuffer[pos2] = ((FastDiffSeekerState)this.current).prevTimestampAndType[8];
            }
            if ((flag & 0x40) == 0) {
                ((FastDiffSeekerState)this.current).valueOffset = this.currentBuffer.position();
                this.currentBuffer.skip(((FastDiffSeekerState)this.current).valueLength);
            }
            if (this.includesTags()) {
                this.decodeTags();
            }
            ((FastDiffSeekerState)this.current).memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
            ((FastDiffSeekerState)this.current).nextKvOffset = this.currentBuffer.position();
        }

        @Override
        protected void decodeFirst() {
            this.currentBuffer.skip(4);
            this.decode(true);
        }

        @Override
        protected void decodeNext() {
            this.decode(false);
        }

        @Override
        protected FastDiffSeekerState createSeekerState() {
            return new FastDiffSeekerState(this.tmpPair, this.includesTags());
        }
    }

    protected static class FastDiffSeekerState
    extends BufferedDataBlockEncoder.SeekerState {
        private byte[] prevTimestampAndType = new byte[9];
        private int rowLengthWithSize;
        private int familyLengthWithSize;

        public FastDiffSeekerState(ObjectIntPair<ByteBuffer> tmpPair, boolean includeTags) {
            super(tmpPair, includeTags);
        }

        @Override
        protected void copyFromNext(BufferedDataBlockEncoder.SeekerState that) {
            super.copyFromNext(that);
            FastDiffSeekerState other = (FastDiffSeekerState)that;
            System.arraycopy(other.prevTimestampAndType, 0, this.prevTimestampAndType, 0, 9);
            this.rowLengthWithSize = other.rowLengthWithSize;
            this.familyLengthWithSize = other.familyLengthWithSize;
        }
    }

    private static class FastDiffCompressionState
    extends CompressionState {
        byte[] timestamp = new byte[8];
        int prevTimestampOffset;

        private FastDiffCompressionState() {
        }

        @Override
        protected void readTimestamp(ByteBuffer in) {
            in.get(this.timestamp);
        }

        @Override
        void copyFrom(CompressionState state) {
            super.copyFrom(state);
            FastDiffCompressionState state2 = (FastDiffCompressionState)state;
            System.arraycopy(state2.timestamp, 0, this.timestamp, 0, 8);
            this.prevTimestampOffset = state2.prevTimestampOffset;
        }

        private void decompressFirstKV(ByteBuffer out, DataInputStream in) throws IOException {
            int kvPos = out.position();
            out.putInt(this.keyLength);
            out.putInt(this.valueLength);
            this.prevTimestampOffset = out.position() + this.keyLength - 9;
            ByteBufferUtils.copyFromStreamToBuffer(out, in, this.keyLength + this.valueLength);
            this.rowLength = out.getShort(kvPos + 8);
            this.familyLength = out.get(kvPos + 8 + 2 + this.rowLength);
            this.type = out.get(this.prevTimestampOffset + 8);
        }
    }
}

