/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FailedServers {
    private final Map<String, Long> failedServers = new HashMap<String, Long>();
    private long latestExpiry = 0L;
    private final int recheckServersTimeout;
    private static final Logger LOG = LoggerFactory.getLogger(FailedServers.class);

    public FailedServers(Configuration conf) {
        this.recheckServersTimeout = conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
    }

    public synchronized void addToFailedServers(InetSocketAddress address2, Throwable throwable) {
        long expiry = EnvironmentEdgeManager.currentTime() + (long)this.recheckServersTimeout;
        this.failedServers.put(address2.toString(), expiry);
        this.latestExpiry = expiry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added failed server with address " + address2.toString() + " to list caused by " + throwable.toString());
        }
    }

    public synchronized boolean isFailedServer(InetSocketAddress address2) {
        if (this.failedServers.isEmpty()) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (now > this.latestExpiry) {
            this.failedServers.clear();
            return false;
        }
        String key2 = address2.toString();
        Long expiry = this.failedServers.get(key2);
        if (expiry == null) {
            return false;
        }
        if (expiry >= now) {
            return true;
        }
        this.failedServers.remove(key2);
        return false;
    }
}

