/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationTableSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsReplicationTableSourceImpl
implements MetricsReplicationTableSource {
    private final MetricsReplicationSourceImpl rms;
    private final String tableName;
    private final String ageOfLastShippedOpKey;
    private String keyPrefix;
    private final String shippedBytesKey;
    private final MutableHistogram ageOfLastShippedOpHist;
    private final MutableFastCounter shippedBytesCounter;

    public MetricsReplicationTableSourceImpl(MetricsReplicationSourceImpl rms, String tableName) {
        this.rms = rms;
        this.tableName = tableName;
        this.keyPrefix = "source." + this.tableName + ".";
        this.ageOfLastShippedOpKey = this.keyPrefix + "ageOfLastShippedOp";
        this.ageOfLastShippedOpHist = rms.getMetricsRegistry().newTimeHistogram(this.ageOfLastShippedOpKey);
        this.shippedBytesKey = this.keyPrefix + "shippedBytes";
        this.shippedBytesCounter = rms.getMetricsRegistry().getCounter(this.shippedBytesKey, 0L);
    }

    @Override
    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpHist.add(age);
    }

    @Override
    public void incrShippedBytes(long size2) {
        this.shippedBytesCounter.incr(size2);
    }

    @Override
    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.shippedBytesKey);
    }

    @Override
    public long getLastShippedAge() {
        return this.ageOfLastShippedOpHist.getMax();
    }

    @Override
    public long getShippedBytes() {
        return this.shippedBytesCounter.value();
    }

    @Override
    public void init() {
        this.rms.init();
    }

    @Override
    public void setGauge(String gaugeName, long value2) {
        this.rms.setGauge(this.keyPrefix + gaugeName, value2);
    }

    @Override
    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(this.keyPrefix + gaugeName, delta);
    }

    @Override
    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(this.keyPrefix + gaugeName, delta);
    }

    @Override
    public void removeMetric(String key2) {
        this.rms.removeMetric(this.keyPrefix + key2);
    }

    @Override
    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(this.keyPrefix + counterName, delta);
    }

    @Override
    public void updateHistogram(String name2, long value2) {
        this.rms.updateHistogram(this.keyPrefix + name2, value2);
    }

    @Override
    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    @Override
    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    @Override
    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    @Override
    public String getMetricsName() {
        return this.rms.getMetricsName();
    }
}

