/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Objects;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class UserPermission {
    private String user;
    private Permission permission;

    public UserPermission(String user, Permission permission) {
        this.user = user;
        this.permission = permission;
    }

    public Permission.Scope getAccessScope() {
        return this.permission.getAccessScope();
    }

    public String getUser() {
        return this.user;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean equalsExceptActions(Object obj) {
        if (!(obj instanceof UserPermission)) {
            return false;
        }
        UserPermission other = (UserPermission)obj;
        return this.user.equals(other.user) && this.permission.equalsExceptActions((Object)other.permission);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserPermission)) {
            return false;
        }
        UserPermission other = (UserPermission)obj;
        return this.user.equals(other.user) && this.permission.equals((Object)other.permission);
    }

    public int hashCode() {
        int prime = 37;
        int result2 = this.permission.hashCode();
        if (this.user != null) {
            result2 = 37 * result2 + Objects.hashCode(this.user);
        }
        return result2;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("UserPermission: ").append("user=").append(this.user).append(", ").append(this.permission.toString());
        return str.toString();
    }
}

