/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.escape.Escaper;
import org.apache.hbase.thirdparty.com.google.common.escape.Escapers;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class JRubyFormat {
    private static final Escaper escaper = Escapers.builder().addEscape('\\', "\\\\").addEscape('\'', "\\'").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\f', "\\f").build();

    private JRubyFormat() {
    }

    private static String escape(Object object) {
        if (object == null) {
            return "";
        }
        return escaper.escape(object.toString());
    }

    private static void appendJRuby(StringBuilder builder, Object object) {
        if (object == null) {
            builder.append("''");
        } else if (object instanceof List) {
            builder.append("[");
            boolean first2 = true;
            for (Object element : (List)object) {
                if (first2) {
                    first2 = false;
                    builder.append(" ");
                } else {
                    builder.append(", ");
                }
                JRubyFormat.appendJRuby(builder, element);
            }
            if (!first2) {
                builder.append(" ");
            }
            builder.append("]");
        } else if (object instanceof Map) {
            builder.append("{");
            boolean first3 = true;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (first3) {
                    first3 = false;
                    builder.append(" ");
                } else {
                    builder.append(", ");
                }
                String key2 = (String)entry.getKey();
                String escapedKey = JRubyFormat.escape(key2);
                if (key2.equals(escapedKey)) {
                    builder.append(key2);
                } else {
                    builder.append("'").append(escapedKey).append("'");
                }
                builder.append(" => ");
                JRubyFormat.appendJRuby(builder, entry.getValue());
            }
            if (!first3) {
                builder.append(" ");
            }
            builder.append("}");
        } else if (object instanceof byte[]) {
            String byteString = Bytes.toHex((byte[])object);
            builder.append("'").append(JRubyFormat.escape(byteString)).append("'");
        } else {
            builder.append("'").append(JRubyFormat.escape(object)).append("'");
        }
    }

    public static String print(Object object) {
        StringBuilder builder = new StringBuilder();
        JRubyFormat.appendJRuby(builder, object);
        return builder.toString();
    }
}

