/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class MurmurHash
extends Hash {
    private static MurmurHash _instance = new MurmurHash();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    public <T> int hash(HashKey<T> hashKey, int seed2) {
        int m = 1540483477;
        int r = 24;
        int length2 = hashKey.length();
        int h = seed2 ^ length2;
        int len_4 = length2 >> 2;
        for (int i2 = 0; i2 < len_4; ++i2) {
            int i_4 = i2 << 2;
            int k = hashKey.get(i_4 + 3);
            k <<= 8;
            k |= hashKey.get(i_4 + 2) & 0xFF;
            k <<= 8;
            k |= hashKey.get(i_4 + 1) & 0xFF;
            k <<= 8;
            k |= hashKey.get(i_4 + 0) & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length2 - len_m;
        int i_m = len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= hashKey.get(i_m + 2) << 16;
            }
            if (left >= 2) {
                h ^= hashKey.get(i_m + 1) << 8;
            }
            if (left >= 1) {
                h ^= hashKey.get(i_m);
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }
}

