/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.hadoop.hbase.util.ObjectPool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WeakObjectPool<K, V>
extends ObjectPool<K, V> {
    public WeakObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory) {
        super(objectFactory);
    }

    public WeakObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory, int initialCapacity) {
        super(objectFactory, initialCapacity);
    }

    public WeakObjectPool(ObjectPool.ObjectFactory<K, V> objectFactory, int initialCapacity, int concurrencyLevel) {
        super(objectFactory, initialCapacity, concurrencyLevel);
    }

    @Override
    public Reference<V> createReference(K key2, V obj) {
        return new WeakObjectReference(key2, obj);
    }

    @Override
    public K getReferenceKey(Reference<V> ref) {
        return ((WeakObjectReference)ref).key;
    }

    private class WeakObjectReference
    extends WeakReference<V> {
        final K key;

        WeakObjectReference(K key2, V obj) {
            super(obj, WeakObjectPool.this.staleRefQueue);
            this.key = key2;
        }
    }
}

