/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKMetadata {
    private static final byte MAGIC = -1;
    private static final int MAGIC_SIZE = 1;
    private static final int ID_LENGTH_OFFSET = 1;
    private static final int ID_LENGTH_SIZE = 4;

    private ZKMetadata() {
    }

    public static byte[] appendMetaData(byte[] id2, byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] salt = Bytes.toBytes(ThreadLocalRandom.current().nextLong());
        int idLength = id2.length + salt.length;
        byte[] newData = new byte[5 + idLength + data.length];
        int pos2 = 0;
        pos2 = Bytes.putByte(newData, pos2, (byte)-1);
        pos2 = Bytes.putInt(newData, pos2, idLength);
        pos2 = Bytes.putBytes(newData, pos2, id2, 0, id2.length);
        pos2 = Bytes.putBytes(newData, pos2, salt, 0, salt.length);
        pos2 = Bytes.putBytes(newData, pos2, data, 0, data.length);
        return newData;
    }

    public static byte[] removeMetaData(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte magic = data[0];
        if (magic != -1) {
            return data;
        }
        int idLength = Bytes.toInt(data, 1);
        int dataLength = data.length - 1 - 4 - idLength;
        int dataOffset = 5 + idLength;
        byte[] newData = new byte[dataLength];
        System.arraycopy(data, dataOffset, newData, 0, dataLength);
        return newData;
    }
}

