/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Stopwatch;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.ZooKeeper;

@InterfaceAudience.Private
public final class ZooKeeperHelper {
    private ZooKeeperHelper() {
    }

    public static ZooKeeper getConnectedZooKeeper(String connectString, int sessionTimeoutMs) throws IOException {
        ZooKeeper zookeeper = new ZooKeeper(connectString, sessionTimeoutMs, e -> {});
        return ZooKeeperHelper.ensureConnectedZooKeeper(zookeeper, sessionTimeoutMs);
    }

    public static ZooKeeper ensureConnectedZooKeeper(ZooKeeper zookeeper, int timeout2) throws ZooKeeperConnectionException {
        if (zookeeper.getState().isConnected()) {
            return zookeeper;
        }
        Stopwatch stopWatch = Stopwatch.createStarted();
        while (!zookeeper.getState().isConnected()) {
            Threads.sleep(1L);
            if (stopWatch.elapsed(TimeUnit.MILLISECONDS) <= (long)timeout2) continue;
            throw new ZooKeeperConnectionException("Failed connect after waiting " + stopWatch.elapsed(TimeUnit.MILLISECONDS) + "ms (zk session timeout); " + zookeeper);
        }
        return zookeeper;
    }
}

