/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;

public abstract class AltKerberosAuthenticationHandler
extends KerberosAuthenticationHandler {
    public static final String TYPE = "alt-kerberos";
    public static final String NON_BROWSER_USER_AGENTS = "alt-kerberos.non-browser.user-agents";
    private static final String NON_BROWSER_USER_AGENTS_DEFAULT = "java,curl,wget,perl";
    private String[] nonBrowserUserAgents;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void init(Properties config) throws ServletException {
        super.init(config);
        this.nonBrowserUserAgents = config.getProperty(NON_BROWSER_USER_AGENTS, NON_BROWSER_USER_AGENTS_DEFAULT).split("\\W*,\\W*");
        for (int i2 = 0; i2 < this.nonBrowserUserAgents.length; ++i2) {
            this.nonBrowserUserAgents[i2] = this.nonBrowserUserAgents[i2].toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = this.isBrowser(request.getHeader("User-Agent")) ? this.alternateAuthenticate(request, response) : super.authenticate(request, response);
        return token;
    }

    protected boolean isBrowser(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.toLowerCase(Locale.ENGLISH);
        boolean isBrowser = true;
        for (String nonBrowserUserAgent : this.nonBrowserUserAgents) {
            if (!userAgent.contains(nonBrowserUserAgent)) continue;
            isBrowser = false;
            break;
        }
        return isBrowser;
    }

    public abstract AuthenticationToken alternateAuthenticate(HttpServletRequest var1, HttpServletResponse var2) throws IOException, AuthenticationException;
}

