/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapter;
import org.apache.hbase.thirdparty.com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import org.apache.hbase.thirdparty.com.google.gson.reflect.TypeToken;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonReader;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;

final class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Gson context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Gson context, TypeAdapter<T> delegate, Type type2) {
        this.context = context;
        this.delegate = delegate;
        this.type = type2;
    }

    @Override
    public T read(JsonReader in) throws IOException {
        return this.delegate.read(in);
    }

    @Override
    public void write(JsonWriter out, T value2) throws IOException {
        TypeAdapter<Object> chosen = this.delegate;
        Type runtimeType = this.getRuntimeTypeIfMoreSpecific(this.type, value2);
        if (runtimeType != this.type) {
            TypeAdapter<?> runtimeTypeAdapter = this.context.getAdapter(TypeToken.get(runtimeType));
            chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.delegate : runtimeTypeAdapter);
        }
        chosen.write(out, value2);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type type2, Object value2) {
        if (value2 != null && (type2 == Object.class || type2 instanceof TypeVariable || type2 instanceof Class)) {
            type2 = value2.getClass();
        }
        return type2;
    }
}

