/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.LazyStringList;
import org.apache.hbase.thirdparty.com.google.protobuf.MapEntryLite;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageLite;
import org.apache.hbase.thirdparty.com.google.protobuf.Schema;
import org.apache.hbase.thirdparty.com.google.protobuf.Writer;

final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream output) {
        if (output.wrapper != null) {
            return output.wrapper;
        }
        return new CodedOutputStreamWriter(output);
    }

    private CodedOutputStreamWriter(CodedOutputStream output) {
        this.output = Internal.checkNotNull(output, "output");
        this.output.wrapper = this;
    }

    @Override
    public Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    @Override
    public void writeSFixed32(int fieldNumber, int value2) throws IOException {
        this.output.writeSFixed32(fieldNumber, value2);
    }

    @Override
    public void writeInt64(int fieldNumber, long value2) throws IOException {
        this.output.writeInt64(fieldNumber, value2);
    }

    @Override
    public void writeSFixed64(int fieldNumber, long value2) throws IOException {
        this.output.writeSFixed64(fieldNumber, value2);
    }

    @Override
    public void writeFloat(int fieldNumber, float value2) throws IOException {
        this.output.writeFloat(fieldNumber, value2);
    }

    @Override
    public void writeDouble(int fieldNumber, double value2) throws IOException {
        this.output.writeDouble(fieldNumber, value2);
    }

    @Override
    public void writeEnum(int fieldNumber, int value2) throws IOException {
        this.output.writeEnum(fieldNumber, value2);
    }

    @Override
    public void writeUInt64(int fieldNumber, long value2) throws IOException {
        this.output.writeUInt64(fieldNumber, value2);
    }

    @Override
    public void writeInt32(int fieldNumber, int value2) throws IOException {
        this.output.writeInt32(fieldNumber, value2);
    }

    @Override
    public void writeFixed64(int fieldNumber, long value2) throws IOException {
        this.output.writeFixed64(fieldNumber, value2);
    }

    @Override
    public void writeFixed32(int fieldNumber, int value2) throws IOException {
        this.output.writeFixed32(fieldNumber, value2);
    }

    @Override
    public void writeBool(int fieldNumber, boolean value2) throws IOException {
        this.output.writeBool(fieldNumber, value2);
    }

    @Override
    public void writeString(int fieldNumber, String value2) throws IOException {
        this.output.writeString(fieldNumber, value2);
    }

    @Override
    public void writeBytes(int fieldNumber, ByteString value2) throws IOException {
        this.output.writeBytes(fieldNumber, value2);
    }

    @Override
    public void writeUInt32(int fieldNumber, int value2) throws IOException {
        this.output.writeUInt32(fieldNumber, value2);
    }

    @Override
    public void writeSInt32(int fieldNumber, int value2) throws IOException {
        this.output.writeSInt32(fieldNumber, value2);
    }

    @Override
    public void writeSInt64(int fieldNumber, long value2) throws IOException {
        this.output.writeSInt64(fieldNumber, value2);
    }

    @Override
    public void writeMessage(int fieldNumber, Object value2) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value2);
    }

    @Override
    public void writeMessage(int fieldNumber, Object value2, Schema schema) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value2, schema);
    }

    @Override
    public void writeGroup(int fieldNumber, Object value2) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value2);
    }

    @Override
    public void writeGroup(int fieldNumber, Object value2, Schema schema) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value2, schema);
    }

    @Override
    public void writeStartGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 3);
    }

    @Override
    public void writeEndGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 4);
    }

    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value2) throws IOException {
        if (value2 instanceof ByteString) {
            this.output.writeRawMessageSetExtension(fieldNumber, (ByteString)value2);
        } else {
            this.output.writeMessageSetExtension(fieldNumber, (MessageLite)value2);
        }
    }

    @Override
    public void writeInt32List(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeInt32NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeInt32(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeFixed32List(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed32SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeFixed32NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeFixed32(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeInt64List(int fieldNumber, List<Long> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeInt64NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeInt64(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeUInt64List(int fieldNumber, List<Long> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeUInt64NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeUInt64(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeFixed64List(int fieldNumber, List<Long> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed64SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeFixed64NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeFixed64(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeFloatList(int fieldNumber, List<Float> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeFloatSizeNoTag(value2.get(i2).floatValue());
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeFloatNoTag(value2.get(i2).floatValue());
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeFloat(fieldNumber, value2.get(i3).floatValue());
            }
        }
    }

    @Override
    public void writeDoubleList(int fieldNumber, List<Double> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeDoubleSizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeDoubleNoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeDouble(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeEnumList(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeEnumNoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeEnum(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeBoolList(int fieldNumber, List<Boolean> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeBoolSizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeBoolNoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeBool(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeStringList(int fieldNumber, List<String> value2) throws IOException {
        if (value2 instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)value2;
            for (int i2 = 0; i2 < value2.size(); ++i2) {
                this.writeLazyString(fieldNumber, lazyList.getRaw(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeString(fieldNumber, value2.get(i3));
            }
        }
    }

    private void writeLazyString(int fieldNumber, Object value2) throws IOException {
        if (value2 instanceof String) {
            this.output.writeString(fieldNumber, (String)value2);
        } else {
            this.output.writeBytes(fieldNumber, (ByteString)value2);
        }
    }

    @Override
    public void writeBytesList(int fieldNumber, List<ByteString> value2) throws IOException {
        for (int i2 = 0; i2 < value2.size(); ++i2) {
            this.output.writeBytes(fieldNumber, value2.get(i2));
        }
    }

    @Override
    public void writeUInt32List(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeUInt32NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeUInt32(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeSFixed32List(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeSFixed32NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeSFixed32(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeSFixed64List(int fieldNumber, List<Long> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeSFixed64NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeSFixed64(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeSInt32List(int fieldNumber, List<Integer> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeSInt32NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeSInt32(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeSInt64List(int fieldNumber, List<Long> value2, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value2.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value2.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value2.size(); ++i2) {
                this.output.writeSInt64NoTag(value2.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value2.size(); ++i3) {
                this.output.writeSInt64(fieldNumber, value2.get(i3));
            }
        }
    }

    @Override
    public void writeMessageList(int fieldNumber, List<?> value2) throws IOException {
        for (int i2 = 0; i2 < value2.size(); ++i2) {
            this.writeMessage(fieldNumber, value2.get(i2));
        }
    }

    @Override
    public void writeMessageList(int fieldNumber, List<?> value2, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value2.size(); ++i2) {
            this.writeMessage(fieldNumber, value2.get(i2), schema);
        }
    }

    @Override
    public void writeGroupList(int fieldNumber, List<?> value2) throws IOException {
        for (int i2 = 0; i2 < value2.size(); ++i2) {
            this.writeGroup(fieldNumber, value2.get(i2));
        }
    }

    @Override
    public void writeGroupList(int fieldNumber, List<?> value2, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value2.size(); ++i2) {
            this.writeGroup(fieldNumber, value2.get(i2), schema);
        }
    }

    @Override
    public <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(fieldNumber, metadata, map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    private <K, V> void writeDeterministicMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V value2 = map.get(Boolean.FALSE);
                if (value2 != null) {
                    this.writeDeterministicBooleanMapEntry(fieldNumber, false, value2, metadata);
                }
                if ((value2 = map.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(fieldNumber, true, value2, metadata);
                break;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(fieldNumber, metadata, map);
                break;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(fieldNumber, metadata, map);
                break;
            }
            case STRING: {
                this.writeDeterministicStringMap(fieldNumber, metadata, map);
                break;
            }
            default: {
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)metadata.keyType));
            }
        }
    }

    private <V> void writeDeterministicBooleanMapEntry(int fieldNumber, boolean key2, V value2, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        this.output.writeTag(fieldNumber, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key2, value2));
        MapEntryLite.writeTo(this.output, metadata, key2, value2);
    }

    private <V> void writeDeterministicIntegerMap(int fieldNumber, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map) throws IOException {
        int[] keys2 = new int[map.size()];
        int index2 = 0;
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int k = iterator.next();
            keys2[index2++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : (Iterator<Integer>)keys2) {
            V value2 = map.get((int)key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)key2, value2));
            MapEntryLite.writeTo(this.output, metadata, (int)key2, value2);
        }
    }

    private <V> void writeDeterministicLongMap(int fieldNumber, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map) throws IOException {
        long[] keys2 = new long[map.size()];
        int index2 = 0;
        Iterator<Long> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            long k = iterator.next();
            keys2[index2++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : (Iterator<Long>)keys2) {
            V value2 = map.get((long)key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)key2, value2));
            MapEntryLite.writeTo(this.output, metadata, (long)key2, value2);
        }
    }

    private <V> void writeDeterministicStringMap(int fieldNumber, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map) throws IOException {
        Object[] keys2 = new String[map.size()];
        int index2 = 0;
        for (String k : map.keySet()) {
            keys2[index2++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : keys2) {
            V value2 = map.get(key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key2, value2));
            MapEntryLite.writeTo(this.output, metadata, key2, value2);
        }
    }
}

