/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hbase.thirdparty.com.google.protobuf.BinaryReader;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistry;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import org.apache.hbase.thirdparty.com.google.protobuf.ExtensionSchema;
import org.apache.hbase.thirdparty.com.google.protobuf.FieldSet;
import org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.LazyField;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageLite;
import org.apache.hbase.thirdparty.com.google.protobuf.Protobuf;
import org.apache.hbase.thirdparty.com.google.protobuf.Reader;
import org.apache.hbase.thirdparty.com.google.protobuf.SchemaUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSchema;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.WireFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.Writer;

final class ExtensionSchemaFull
extends ExtensionSchema<Descriptors.FieldDescriptor> {
    private static final long EXTENSION_FIELD_OFFSET = ExtensionSchemaFull.getExtensionsFieldOffset();

    ExtensionSchemaFull() {
    }

    private static <T> long getExtensionsFieldOffset() {
        try {
            Field field2 = GeneratedMessageV3.ExtendableMessage.class.getDeclaredField("extensions");
            return UnsafeUtil.objectFieldOffset(field2);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to lookup extension field offset");
        }
    }

    @Override
    boolean hasExtensions(MessageLite prototype) {
        return prototype instanceof GeneratedMessageV3.ExtendableMessage;
    }

    @Override
    public FieldSet<Descriptors.FieldDescriptor> getExtensions(Object message2) {
        return (FieldSet)UnsafeUtil.getObject(message2, EXTENSION_FIELD_OFFSET);
    }

    @Override
    void setExtensions(Object message2, FieldSet<Descriptors.FieldDescriptor> extensions) {
        UnsafeUtil.putObject(message2, EXTENSION_FIELD_OFFSET, extensions);
    }

    @Override
    FieldSet<Descriptors.FieldDescriptor> getMutableExtensions(Object message2) {
        FieldSet<Descriptors.FieldDescriptor> extensions = this.getExtensions(message2);
        if (extensions.isImmutable()) {
            extensions = extensions.clone();
            this.setExtensions(message2, extensions);
        }
        return extensions;
    }

    @Override
    void makeImmutable(Object message2) {
        this.getExtensions(message2).makeImmutable();
    }

    @Override
    <UT, UB> UB parseExtension(Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        ExtensionRegistry.ExtensionInfo extension = (ExtensionRegistry.ExtensionInfo)extensionObject;
        int fieldNumber = extension.descriptor.getNumber();
        if (extension.descriptor.isRepeated() && extension.descriptor.isPacked()) {
            ArrayList<Object> value2 = null;
            switch (extension.descriptor.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list2 = new ArrayList<Double>();
                    reader.readDoubleList(list2);
                    value2 = list2;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list3 = new ArrayList<Float>();
                    reader.readFloatList(list3);
                    value2 = list3;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list4 = new ArrayList<Long>();
                    reader.readInt64List(list4);
                    value2 = list4;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list5 = new ArrayList<Long>();
                    reader.readUInt64List(list5);
                    value2 = list5;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list6 = new ArrayList<Integer>();
                    reader.readInt32List(list6);
                    value2 = list6;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list7 = new ArrayList<Long>();
                    reader.readFixed64List(list7);
                    value2 = list7;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list8 = new ArrayList<Integer>();
                    reader.readFixed32List(list8);
                    value2 = list8;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list9 = new ArrayList<Boolean>();
                    reader.readBoolList(list9);
                    value2 = list9;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list10 = new ArrayList<Integer>();
                    reader.readUInt32List(list10);
                    value2 = list10;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list11 = new ArrayList<Integer>();
                    reader.readSFixed32List(list11);
                    value2 = list11;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list12 = new ArrayList<Long>();
                    reader.readSFixed64List(list12);
                    value2 = list12;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list13 = new ArrayList<Integer>();
                    reader.readSInt32List(list13);
                    value2 = list13;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list14 = new ArrayList<Long>();
                    reader.readSInt64List(list14);
                    value2 = list14;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list15 = new ArrayList<Integer>();
                    reader.readEnumList(list15);
                    ArrayList<Descriptors.EnumValueDescriptor> enumList = new ArrayList<Descriptors.EnumValueDescriptor>();
                    Iterator iterator = list15.iterator();
                    while (iterator.hasNext()) {
                        int number = (Integer)iterator.next();
                        Descriptors.EnumValueDescriptor enumDescriptor = extension.descriptor.getEnumType().findValueByNumber(number);
                        if (enumDescriptor != null) {
                            enumList.add(enumDescriptor);
                            continue;
                        }
                        unknownFields = SchemaUtil.storeUnknownEnum(fieldNumber, number, unknownFields, unknownFieldSchema);
                    }
                    value2 = enumList;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                }
            }
            extensions.setField(extension.descriptor, value2);
        } else {
            Object value3 = null;
            if (extension.descriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                int number = reader.readInt32();
                Descriptors.EnumValueDescriptor enumValue = extension.descriptor.getEnumType().findValueByNumber(number);
                if (enumValue == null) {
                    return SchemaUtil.storeUnknownEnum(fieldNumber, number, unknownFields, unknownFieldSchema);
                }
                value3 = enumValue;
            } else {
                switch (extension.descriptor.getLiteType()) {
                    case DOUBLE: {
                        value3 = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value3 = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        value3 = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        value3 = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        value3 = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value3 = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value3 = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value3 = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        value3 = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        value3 = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value3 = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value3 = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value3 = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value3 = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        value3 = reader.readString();
                        break;
                    }
                    case GROUP: {
                        value3 = reader.readGroup(extension.defaultInstance.getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        value3 = reader.readMessage(extension.defaultInstance.getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension.descriptor.isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, value3);
            } else {
                switch (extension.descriptor.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension.descriptor);
                        if (oldValue == null) break;
                        value3 = Internal.mergeMessage(oldValue, value3);
                        break;
                    }
                }
                extensions.setField(extension.descriptor, value3);
            }
        }
        return unknownFields;
    }

    @Override
    int extensionNumber(Map.Entry<?, ?> extension) {
        Descriptors.FieldDescriptor descriptor = (Descriptors.FieldDescriptor)extension.getKey();
        return descriptor.getNumber();
    }

    @Override
    void serializeExtension(Writer writer, Map.Entry<?, ?> extension) throws IOException {
        Descriptors.FieldDescriptor descriptor = (Descriptors.FieldDescriptor)extension.getKey();
        if (descriptor.isRepeated()) {
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    SchemaUtil.writeDoubleList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FLOAT: {
                    SchemaUtil.writeFloatList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case INT64: {
                    SchemaUtil.writeInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case UINT64: {
                    SchemaUtil.writeUInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case INT32: {
                    SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FIXED64: {
                    SchemaUtil.writeFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FIXED32: {
                    SchemaUtil.writeFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case BOOL: {
                    SchemaUtil.writeBoolList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case BYTES: {
                    SchemaUtil.writeBytesList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case UINT32: {
                    SchemaUtil.writeUInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SFIXED32: {
                    SchemaUtil.writeSFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SFIXED64: {
                    SchemaUtil.writeSFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SINT32: {
                    SchemaUtil.writeSInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SINT64: {
                    SchemaUtil.writeSInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case ENUM: {
                    List enumList = (List)extension.getValue();
                    ArrayList<Integer> list2 = new ArrayList<Integer>();
                    for (Descriptors.EnumValueDescriptor d : enumList) {
                        list2.add(d.getNumber());
                    }
                    SchemaUtil.writeInt32List(descriptor.getNumber(), list2, writer, descriptor.isPacked());
                    break;
                }
                case STRING: {
                    SchemaUtil.writeStringList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case GROUP: {
                    SchemaUtil.writeGroupList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case MESSAGE: {
                    SchemaUtil.writeMessageList(descriptor.getNumber(), (List)extension.getValue(), writer);
                }
            }
        } else {
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    writer.writeDouble(descriptor.getNumber(), (Double)extension.getValue());
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(descriptor.getNumber(), ((Float)extension.getValue()).floatValue());
                    break;
                }
                case INT64: {
                    writer.writeInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case UINT64: {
                    writer.writeUInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case INT32: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case FIXED64: {
                    writer.writeFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case FIXED32: {
                    writer.writeFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case BOOL: {
                    writer.writeBool(descriptor.getNumber(), (Boolean)extension.getValue());
                    break;
                }
                case BYTES: {
                    writer.writeBytes(descriptor.getNumber(), (ByteString)extension.getValue());
                    break;
                }
                case UINT32: {
                    writer.writeUInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED32: {
                    writer.writeSFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED64: {
                    writer.writeSFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case SINT32: {
                    writer.writeSInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SINT64: {
                    writer.writeSInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case ENUM: {
                    writer.writeInt32(descriptor.getNumber(), ((Descriptors.EnumValueDescriptor)extension.getValue()).getNumber());
                    break;
                }
                case STRING: {
                    writer.writeString(descriptor.getNumber(), (String)extension.getValue());
                    break;
                }
                case GROUP: {
                    writer.writeGroup(descriptor.getNumber(), extension.getValue());
                    break;
                }
                case MESSAGE: {
                    writer.writeMessage(descriptor.getNumber(), extension.getValue());
                }
            }
        }
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number) {
        return ((ExtensionRegistry)extensionRegistry).findExtensionByNumber(((Message)defaultInstance).getDescriptorForType(), number);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader, Object extension, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
        ExtensionRegistry.ExtensionInfo extensionInfo = (ExtensionRegistry.ExtensionInfo)extension;
        if (ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            Object value2 = reader.readMessage(extensionInfo.defaultInstance.getClass(), extensionRegistry);
            extensions.setField(extensionInfo.descriptor, value2);
        } else {
            extensions.setField(extensionInfo.descriptor, new LazyField(extensionInfo.defaultInstance, extensionRegistry, reader.readBytes()));
        }
    }

    @Override
    void parseMessageSetItem(ByteString data, Object extension, ExtensionRegistryLite extensionRegistry, FieldSet<Descriptors.FieldDescriptor> extensions) throws IOException {
        ExtensionRegistry.ExtensionInfo extensionInfo = (ExtensionRegistry.ExtensionInfo)extension;
        Message value2 = extensionInfo.defaultInstance.newBuilderForType().buildPartial();
        if (ExtensionRegistryLite.isEagerlyParseMessageSets()) {
            BinaryReader reader = BinaryReader.newInstance(ByteBuffer.wrap(data.toByteArray()), true);
            Protobuf.getInstance().mergeFrom(value2, reader, extensionRegistry);
            extensions.setField(extensionInfo.descriptor, value2);
            if (reader.getFieldNumber() != Integer.MAX_VALUE) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        } else {
            extensions.setField(extensionInfo.descriptor, new LazyField(extensionInfo.defaultInstance, extensionRegistry, data));
        }
    }
}

