/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.FieldMask;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.util.FieldMaskUtil;

final class FieldMaskTree {
    private static final Logger logger = Logger.getLogger(FieldMaskTree.class.getName());
    private static final String FIELD_PATH_SEPARATOR_REGEX = "\\.";
    private final Node root = new Node();

    FieldMaskTree() {
    }

    FieldMaskTree(FieldMask mask) {
        this.mergeFromFieldMask(mask);
    }

    public String toString() {
        return FieldMaskUtil.toString(this.toFieldMask());
    }

    @CanIgnoreReturnValue
    FieldMaskTree addFieldPath(String path2) {
        String[] parts = path2.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return this;
        }
        Node node = this.root;
        boolean createNewBranch = false;
        for (String part : parts) {
            if (!createNewBranch && node != this.root && node.children.isEmpty()) {
                return this;
            }
            if (node.children.containsKey(part)) {
                node = (Node)node.children.get(part);
                continue;
            }
            createNewBranch = true;
            Node tmp = new Node();
            node.children.put(part, tmp);
            node = tmp;
        }
        node.children.clear();
        return this;
    }

    @CanIgnoreReturnValue
    FieldMaskTree mergeFromFieldMask(FieldMask mask) {
        for (String path2 : mask.getPathsList()) {
            this.addFieldPath(path2);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FieldMaskTree removeFieldPath(String path2) {
        List<String> parts = Splitter.onPattern(FIELD_PATH_SEPARATOR_REGEX).splitToList(path2);
        if (parts.isEmpty()) {
            return this;
        }
        FieldMaskTree.removeFieldPath(this.root, parts, 0);
        return this;
    }

    @CanIgnoreReturnValue
    private static boolean removeFieldPath(Node node, List<String> parts, int index2) {
        String key2 = parts.get(index2);
        if (!node.children.containsKey(key2)) {
            return false;
        }
        if (index2 == parts.size() - 1) {
            node.children.remove(key2);
            return node.children.isEmpty();
        }
        if (FieldMaskTree.removeFieldPath((Node)node.children.get(key2), parts, index2 + 1)) {
            node.children.remove(key2);
        }
        return node.children.isEmpty();
    }

    @CanIgnoreReturnValue
    FieldMaskTree removeFromFieldMask(FieldMask mask) {
        for (String path2 : mask.getPathsList()) {
            this.removeFieldPath(path2);
        }
        return this;
    }

    FieldMask toFieldMask() {
        if (this.root.children.isEmpty()) {
            return FieldMask.getDefaultInstance();
        }
        ArrayList<String> paths = new ArrayList<String>();
        FieldMaskTree.getFieldPaths(this.root, "", paths);
        return FieldMask.newBuilder().addAllPaths(paths).build();
    }

    private static void getFieldPaths(Node node, String path2, List<String> paths) {
        if (node.children.isEmpty()) {
            paths.add(path2);
            return;
        }
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            String childPath = path2.isEmpty() ? entry.getKey() : path2 + "." + entry.getKey();
            FieldMaskTree.getFieldPaths(entry.getValue(), childPath, paths);
        }
    }

    void intersectFieldPath(String path2, FieldMaskTree output) {
        if (this.root.children.isEmpty()) {
            return;
        }
        String[] parts = path2.split(FIELD_PATH_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return;
        }
        Node node = this.root;
        for (String part : parts) {
            if (node != this.root && node.children.isEmpty()) {
                output.addFieldPath(path2);
                return;
            }
            if (!node.children.containsKey(part)) {
                return;
            }
            node = (Node)node.children.get(part);
        }
        ArrayList<String> paths = new ArrayList<String>();
        FieldMaskTree.getFieldPaths(node, path2, paths);
        for (String value2 : paths) {
            output.addFieldPath(value2);
        }
    }

    void merge(Message source2, Message.Builder destination, FieldMaskUtil.MergeOptions options2) {
        if (source2.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException("Cannot merge messages of different types.");
        }
        if (this.root.children.isEmpty()) {
            return;
        }
        FieldMaskTree.merge(this.root, "", source2, destination, options2);
    }

    private static void merge(Node node, String path2, Message source2, Message.Builder destination, FieldMaskUtil.MergeOptions options2) {
        if (source2.getDescriptorForType() != destination.getDescriptorForType()) {
            throw new IllegalArgumentException(String.format("source (%s) and destination (%s) descriptor must be equal", source2.getDescriptorForType(), destination.getDescriptorForType()));
        }
        Descriptors.Descriptor descriptor = source2.getDescriptorForType();
        for (Map.Entry<String, Node> entry : node.children.entrySet()) {
            Descriptors.FieldDescriptor field2 = descriptor.findFieldByName(entry.getKey());
            if (field2 == null) {
                logger.warning("Cannot find field \"" + entry.getKey() + "\" in message type " + descriptor.getFullName());
                continue;
            }
            if (!entry.getValue().children.isEmpty()) {
                if (field2.isRepeated() || field2.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    logger.warning("Field \"" + field2.getFullName() + "\" is not a singular message field and cannot have sub-fields.");
                    continue;
                }
                if (!source2.hasField(field2) && !destination.hasField(field2)) continue;
                String childPath = path2.isEmpty() ? entry.getKey() : path2 + "." + entry.getKey();
                Message.Builder childBuilder = ((Message)destination.getField(field2)).toBuilder();
                FieldMaskTree.merge(entry.getValue(), childPath, (Message)source2.getField(field2), childBuilder, options2);
                destination.setField(field2, childBuilder.buildPartial());
                continue;
            }
            if (field2.isRepeated()) {
                if (options2.replaceRepeatedFields()) {
                    destination.setField(field2, source2.getField(field2));
                    continue;
                }
                for (Object element : (List)source2.getField(field2)) {
                    destination.addRepeatedField(field2, element);
                }
                continue;
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (options2.replaceMessageFields()) {
                    if (!source2.hasField(field2)) {
                        destination.clearField(field2);
                        continue;
                    }
                    destination.setField(field2, source2.getField(field2));
                    continue;
                }
                if (!source2.hasField(field2)) continue;
                destination.setField(field2, ((Message)destination.getField(field2)).toBuilder().mergeFrom((Message)source2.getField(field2)).build());
                continue;
            }
            if (source2.hasField(field2) || !options2.replacePrimitiveFields()) {
                destination.setField(field2, source2.getField(field2));
                continue;
            }
            destination.clearField(field2);
        }
    }

    private static final class Node {
        final SortedMap<String, Node> children = new TreeMap<String, Node>();

        private Node() {
        }
    }
}

